<?php
    // ==========================================
    // Clase: InformeCortesia
    // Autor: John Christian Tello Vilca
    // Descripción: Representa los registros de cortesía
    // ==========================================
    class InformeCortesia {

        // ======= Atributos =======
        private $idCortesia;           // INT IDENTITY(1,1)
        private $fechaRegCortesia;     // DATETIME DEFAULT GETDATE()
        private $checkCortesia;        // DECIMAL(10,0)
        private $nombreBeneficiario;   // VARCHAR(100)
        private $motivoCortesia;       // VARCHAR(500)
        private $montoCortesia;        // DECIMAL(10,2)
        private $idResponsable;        // VARCHAR(100)
        private $idUsuario;            // VARCHAR(100)

        // ======= Constructor =======
        public function __construct(
            $idCortesia = null,
            $fechaRegCortesia = null,
            $checkCortesia = null,
            $nombreBeneficiario = null,
            $motivoCortesia = null,
            $montoCortesia = null,
            $idResponsable = null,
            $idUsuario = null
        ) {
            $this->idCortesia        = $idCortesia;
            $this->fechaRegCortesia  = $fechaRegCortesia;
            $this->checkCortesia     = $checkCortesia;
            $this->nombreBeneficiario = $nombreBeneficiario;
            $this->motivoCortesia    = $motivoCortesia;
            $this->montoCortesia     = $montoCortesia;
            $this->idResponsable     = $idResponsable;
            $this->idUsuario         = $idUsuario;
        }

        // ======= Getters y Setters =======

        public function getIdCortesia() { return $this->idCortesia; }
        public function setIdCortesia($idCortesia) { $this->idCortesia = $idCortesia; }

        public function getFechaRegCortesia() { return $this->fechaRegCortesia; }
        public function setFechaRegCortesia($fechaRegCortesia) { $this->fechaRegCortesia = $fechaRegCortesia; }

        public function getCheckCortesia() { return $this->checkCortesia; }
        public function setCheckCortesia($checkCortesia) { $this->checkCortesia = $checkCortesia; }

        public function getNombreBeneficiario() { return $this->nombreBeneficiario; }
        public function setNombreBeneficiario($nombreBeneficiario) { $this->nombreBeneficiario = $nombreBeneficiario; }

        public function getMotivoCortesia() { return $this->motivoCortesia; }
        public function setMotivoCortesia($motivoCortesia) { $this->motivoCortesia = $motivoCortesia; }

        public function getMontoCortesia() { return $this->montoCortesia; }
        public function setMontoCortesia($montoCortesia) { $this->montoCortesia = $montoCortesia; }

        public function getIdResponsable() { return $this->idResponsable; }
        public function setIdResponsable($idResponsable) { $this->idResponsable = $idResponsable; }

        public function getIdUsuario() { return $this->idUsuario; }
        public function setIdUsuario($idUsuario) { $this->idUsuario = $idUsuario; }
    }
?>
