<?php
    // ==========================================
    // Clase: InformeEliminado
    // Autor: John Christian Tello Vilca
    // Descripción: Representa los registros de productos eliminados
    // Tabla: INFORME_ELIMINADO
    // ==========================================
    class InformeEliminado {

        // ======= Atributos (columnas) =======
        private $idEliminado;            // INT IDENTITY(1,1) PK
        private $fechaRegEliminado;      // DATETIME DEFAULT GETDATE()
        private $idEmpleado;             // VARCHAR(100)  NOT NULL
        private $idCategoria;            // VARCHAR(100)  NOT NULL (fk CATEGORIA_PRODUCTO.ID_CATEGORIA)
        private $idProducto;             // VARCHAR(100)  NOT NULL (fk PRODUCTO.ID_PRODUCTO)
        private $unidadEliminado;        // INT           NOT NULL
        private $precioProducto;         // DECIMAL(10,2) NOT NULL
        private $motivoEliminado;        // VARCHAR(100)  NOT NULL (CHECK lista)
        private $totalMontoEliminado;    // DECIMAL(12,2) NULL/Calculable
        private $idResponsable;          // VARCHAR(100)  NOT NULL (fk RESPONSABLE.ID_RESPONSABLE)
        private $idUsuario;              // VARCHAR(100)  NOT NULL (fk USUARIO.ID_USUARIO)

        // ======= Constructor =======
        public function __construct(
            $idEliminado = null,
            $fechaRegEliminado = null,
            $idEmpleado = null,
            $idCategoria = null,
            $idProducto = null,
            $unidadEliminado = null,
            $precioProducto = null,
            $motivoEliminado = null,
            $totalMontoEliminado = null,
            $idResponsable = null,
            $idUsuario = null
        ) {
            $this->idEliminado         = $idEliminado;
            $this->fechaRegEliminado   = $fechaRegEliminado;
            $this->idEmpleado          = $idEmpleado;
            $this->idCategoria         = $idCategoria;
            $this->idProducto          = $idProducto;
            $this->unidadEliminado     = $unidadEliminado;
            $this->precioProducto      = $precioProducto;
            $this->motivoEliminado     = $motivoEliminado;
            $this->totalMontoEliminado = $totalMontoEliminado;
            $this->idResponsable       = $idResponsable;
            $this->idUsuario           = $idUsuario;
        }

        // ======= Getters y Setters =======
        public function getIdEliminado() { return $this->idEliminado; }
        public function setIdEliminado($idEliminado) { $this->idEliminado = $idEliminado; }

        public function getFechaRegEliminado() { return $this->fechaRegEliminado; }
        public function setFechaRegEliminado($fechaRegEliminado) { $this->fechaRegEliminado = $fechaRegEliminado; }

        public function getIdEmpleado() { return $this->idEmpleado; }
        public function setIdEmpleado($idEmpleado) { $this->idEmpleado = $idEmpleado; }

        public function getIdCategoria() { return $this->idCategoria; }
        public function setIdCategoria($idCategoria) { $this->idCategoria = $idCategoria; }

        public function getIdProducto() { return $this->idProducto; }
        public function setIdProducto($idProducto) { $this->idProducto = $idProducto; }

        public function getUnidadEliminado() { return $this->unidadEliminado; }
        public function setUnidadEliminado($unidadEliminado) { $this->unidadEliminado = $unidadEliminado; }

        public function getPrecioProducto() { return $this->precioProducto; }
        public function setPrecioProducto($precioProducto) { $this->precioProducto = $precioProducto; }

        public function getMotivoEliminado() { return $this->motivoEliminado; }
        public function setMotivoEliminado($motivoEliminado) { $this->motivoEliminado = $motivoEliminado; }

        public function getTotalMontoEliminado() { return $this->totalMontoEliminado; }
        public function setTotalMontoEliminado($totalMontoEliminado) { $this->totalMontoEliminado = $totalMontoEliminado; }

        public function getIdResponsable() { return $this->idResponsable; }
        public function setIdResponsable($idResponsable) { $this->idResponsable = $idResponsable; }

        public function getIdUsuario() { return $this->idUsuario; }
        public function setIdUsuario($idUsuario) { $this->idUsuario = $idUsuario; }
    }
?>
