<?php
    class PropinaFisico {
        private $idPropFisico;       // INT IDENTITY
        private $fechaRegFisico;     // DATETIME (DEFAULT GETDATE())
        private $idEmpleado;         // FK -> EMPLEADO(ID_EMPLEADO)
        private $montoPropFisico;    // DECIMAL(10,2)
        private $idUsuario;          // FK -> USUARIO(ID_USUARIO)

        // Constructor (id y fecha son opcionales porque los pone SQL)
        public function __construct(
            ?int $idPropFisico = null,
            ?string $fechaRegFisico = null,
            string $idEmpleado = '',
            float $montoPropFisico = 0.0,
            string $idUsuario = ''
        ) {
            $this->idPropFisico    = $idPropFisico;
            $this->fechaRegFisico  = $fechaRegFisico; // puede venir como string 'Y-m-d H:i:s'
            $this->idEmpleado      = $idEmpleado;
            $this->montoPropFisico = $montoPropFisico;
            $this->idUsuario       = $idUsuario;
        }

        // Getters / Setters
        public function getIdPropFisico(): ?int { return $this->idPropFisico; }
        public function setIdPropFisico(?int $id): void { $this->idPropFisico = $id; }

        public function getFechaRegFisico(): ?string { return $this->fechaRegFisico; }
        public function setFechaRegFisico(?string $fecha): void { $this->fechaRegFisico = $fecha; }

        public function getIdEmpleado(): string { return $this->idEmpleado; }
        public function setIdEmpleado(string $idEmpleado): void { $this->idEmpleado = $idEmpleado; }

        public function getMontoPropFisico(): float { return $this->montoPropFisico; }
        public function setMontoPropFisico(float $monto): void { $this->montoPropFisico = $monto; }

        public function getIdUsuario(): string { return $this->idUsuario; }
        public function setIdUsuario(string $idUsuario): void { $this->idUsuario = $idUsuario; }
    }
?>