<?php
    class PropinaTarjeta {
        private $idPropinaTarjeta;   // INT IDENTITY
        private $fechaRegTarjeta;    // DATETIME (DEFAULT GETDATE())
        private $idPropReff;         // VARCHAR(10)
        private $idEmpleado;         // FK -> EMPLEADO(ID_EMPLEADO)
        private $monTarjeta;         // DECIMAL(10,2)
        private $descMonTarjeta;     // DECIMAL(10,2)
        private $idUsuario;          // FK -> USUARIO(ID_USUARIO)

        // Constructor (id y fecha son opcionales porque los pone SQL)
        public function __construct(
            ?int $idPropinaTarjeta = null,
            ?string $fechaRegTarjeta = null,
            string $idPropReff = '',
            string $idEmpleado = '',
            float $monTarjeta = 0.0,
            float $descMonTarjeta = 0.0,
            string $idUsuario = ''
        ) {
            $this->idPropinaTarjeta = $idPropinaTarjeta;
            $this->fechaRegTarjeta  = $fechaRegTarjeta; // puede venir como 'Y-m-d H:i:s'
            $this->idPropReff       = $idPropReff;
            $this->idEmpleado       = $idEmpleado;
            $this->monTarjeta       = $monTarjeta;
            $this->descMonTarjeta   = $descMonTarjeta;
            $this->idUsuario        = $idUsuario;
        }

        // ===== Getters y Setters =====

        public function getIdPropinaTarjeta(): ?int {
            return $this->idPropinaTarjeta;
        }
        public function setIdPropinaTarjeta(?int $id): void {
            $this->idPropinaTarjeta = $id;
        }

        public function getFechaRegTarjeta(): ?string {
            return $this->fechaRegTarjeta;
        }
        public function setFechaRegTarjeta(?string $fecha): void {
            $this->fechaRegTarjeta = $fecha;
        }

        public function getIdPropReff(): string {
            return $this->idPropReff;
        }
        public function setIdPropReff(string $idPropReff): void {
            $this->idPropReff = $idPropReff;
        }

        public function getIdEmpleado(): string {
            return $this->idEmpleado;
        }
        public function setIdEmpleado(string $idEmpleado): void {
            $this->idEmpleado = $idEmpleado;
        }

        public function getMonTarjeta(): float {
            return $this->monTarjeta;
        }
        public function setMonTarjeta(float $monto): void {
            $this->monTarjeta = $monto;
        }

        public function getDescMonTarjeta(): float {
            return $this->descMonTarjeta;
        }
        public function setDescMonTarjeta(float $descuento): void {
            $this->descMonTarjeta = $descuento;
        }

        public function getIdUsuario(): string {
            return $this->idUsuario;
        }
        public function setIdUsuario(string $idUsuario): void {
            $this->idUsuario = $idUsuario;
        }
    }
?>
