<?php
    // Ubicación sugerida: /backend/dao/InformeCortesiaDAO.php
    require_once __DIR__ . '/../clases/InformeCortesia.php';

    class InformeCortesiaDAO {
        private $conn;

        public function __construct($conn) {
            $this->conn = $conn;
        }

        // ============================================
        // INSERTAR registro (retorna true/false)
        // ============================================
        public function insertar(InformeCortesia $cortesia) {
            $sql = "INSERT INTO INFORME_CORTESIA
                    (CHECK_CORTESIA, NOMBRE_BENEFICIARIO, MOTIVO_CORTESIA, MONTO_CORTESIA, ID_RESPONSABLE, ID_USUARIO)
                    VALUES (?, ?, ?, ?, ?, ?)";

            $params = [
                $cortesia->getCheckCortesia(),
                $cortesia->getNombreBeneficiario(),
                $cortesia->getMotivoCortesia(),
                $cortesia->getMontoCortesia(),
                $cortesia->getIdResponsable(),
                $cortesia->getIdUsuario()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // ============================================
        // LISTAR registros del día actual
        // ============================================
        public function listarTodos() {
            $sql = "SELECT
                        ID_CORTESIA,
                        FECHA_REG_CORTESIA,
                        CHECK_CORTESIA,
                        NOMBRE_BENEFICIARIO,
                        MOTIVO_CORTESIA,
                        MONTO_CORTESIA,
                        ID_RESPONSABLE,
                        ID_USUARIO
                    FROM INFORME_CORTESIA
                    WHERE CONVERT(date, FECHA_REG_CORTESIA) = CONVERT(date, GETDATE())
                    ORDER BY ID_CORTESIA DESC";

            $stmt = sqlsrv_query($this->conn, $sql);
            if ($stmt === false) {
                return [];
            }

            $rows = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                // Formatear fecha (si llega como objeto DateTime)
                if (isset($row['FECHA_REG_CORTESIA']) && $row['FECHA_REG_CORTESIA'] instanceof DateTime) {
                    $row['FECHA_REG_CORTESIA'] = $row['FECHA_REG_CORTESIA']->format('Y-m-d H:i:s');
                }
                $rows[] = $row;
            }
            return $rows;
        }

        // ============================================
        // RESUMEN del día (cantidad y total)
        // ============================================
        public function resumenDelDia() {
            $sql = "SELECT 
                        COUNT(*) AS CANTIDAD_CORTESIAS,
                        ISNULL(SUM(MONTO_CORTESIA), 0) AS TOTAL_CORTESIA
                    FROM INFORME_CORTESIA
                    WHERE CONVERT(date, FECHA_REG_CORTESIA) = CONVERT(date, GETDATE())";

            $stmt = sqlsrv_query($this->conn, $sql);
            if ($stmt === false) {
                return ['CANTIDAD_CORTESIAS' => 0, 'TOTAL_CORTESIA' => 0];
            }

            $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
            return [
                'CANTIDAD_CORTESIAS' => (int)$row['CANTIDAD_CORTESIAS'],
                'TOTAL_CORTESIA' => (float)$row['TOTAL_CORTESIA']
            ];
        }
    }
?>
