<?php
    require_once __DIR__ . '/../clases/InformeGasto.php';

    class InformeGastoDAO {
        private $conn;
        private int $decimalesMonto = 2;

        public function __construct($conn){ $this->conn = $conn; }

        private function normTxt(?string $s): ?string {
            if ($s === null) return null;
            $s = trim(preg_replace('/\s+/', ' ', $s));
            return $s === '' ? null : $s;
        }
        private function normMonto($m): float {
            $v = is_numeric($m) ? (float)$m : 0.0;
            return round(max(0.0, $v), $this->decimalesMonto);
        }

        // INSERT: retorna ID_GASTO o null
        public function insertar(InformeGasto $g): ?int {
            $persona   = $this->normTxt($g->getPersonaEntregada());
            $motivo    = $this->normTxt($g->getMotivoGasto());
            $monto     = $this->normMonto($g->getMontoGasto());
            $idUsuario = $this->normTxt($g->getIdUsuario());

            if (!$persona || !$idUsuario) return null;

            $sql = "INSERT INTO INFORME_GASTO (PERSONA_ENTREGADA, MOTIVO_GASTO, MONTO_GASTO, ID_USUARIO)
                    OUTPUT INSERTED.ID_GASTO
                    VALUES (?, ?, ?, ?)";
            $params = [$persona, $motivo, $monto, $idUsuario];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            if ($stmt === false) return null;

            $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
            return $row['ID_GASTO'] ?? null;
        }

        public function listarHoy(): array {
            $sql = "SELECT ID_GASTO, FECHA_REG_GASTO, PERSONA_ENTREGADA, MOTIVO_GASTO, MONTO_GASTO, ID_USUARIO
                    FROM INFORME_GASTO
                    WHERE CONVERT(date, FECHA_REG_GASTO) = CONVERT(date, GETDATE())
                    ORDER BY ID_GASTO DESC";
            $stmt = sqlsrv_query($this->conn, $sql);
            if ($stmt === false) return [];

            $rows = [];
            while ($r = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                if (!empty($r['FECHA_REG_GASTO']) && $r['FECHA_REG_GASTO'] instanceof DateTime) {
                    $r['FECHA_REG_GASTO'] = $r['FECHA_REG_GASTO']->format('Y-m-d H:i:s');
                }
                $rows[] = $r;
            }
            return $rows;
        }
    }
?>