<?php
    require_once __DIR__ . '/../clases/Pos.php';

    class PosDAO {
        private $conn;

        public function __construct($conn) {
            $this->conn = $conn;
        }

        // INSERTAR
        public function insertar(Pos $pos): bool {
            $sql = "INSERT INTO POS (ID_POS, LOCAL_POS, MARCA_POS, ESTADO_POS)
                    VALUES (?, ?, ?, ?)";
            $params = [
                $pos->getIdPos(),
                $pos->getLocalPos(),
                $pos->getMarcaPos(),
                $pos->getEstadoPos()
            ];
            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // LISTAR -> devuelve arrays asociativos
        public function listarTodos(?string $estado = null): array {
            $sql = "SELECT ID_POS, LOCAL_POS, MARCA_POS, ESTADO_POS FROM POS";
            $params = [];

            if ($estado !== null) {
                $sql .= " WHERE ESTADO_POS = ?";
                $params[] = strtoupper(trim($estado));
            }

            $sql .= " ORDER BY ID_POS";

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            if ($stmt === false) return [];

            $rows = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                $rows[] = $row;
            }
            return $rows;
        }

        // BUSCAR POR ID
        public function buscarPorId($idPos): ?array {
            $sql = "SELECT ID_POS, LOCAL_POS, MARCA_POS, ESTADO_POS
                    FROM POS WHERE ID_POS = ?";
            $stmt = sqlsrv_query($this->conn, $sql, [$idPos]);
            if ($stmt === false) return null;

            $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
            return $row ?: null;
        }

        // ACTUALIZAR
        public function actualizar(Pos $pos): bool {
            $sql = "UPDATE POS
                    SET LOCAL_POS = ?, 
                        MARCA_POS = ?, 
                        ESTADO_POS = ?
                    WHERE ID_POS = ?";
            $params = [
                $pos->getLocalPos(),
                $pos->getMarcaPos(),
                $pos->getEstadoPos(),
                $pos->getIdPos()
            ];
            $stmt = sqlsrv_query($this->conn, $sql, $params);
            if ($stmt === false) return false;

            $rows = sqlsrv_rows_affected($stmt);
            return $rows !== false && $rows > 0;
        }

        // ELIMINAR
        public function eliminar($idPos): bool {
            $sql = "DELETE FROM POS WHERE ID_POS = ?";
            $stmt = sqlsrv_query($this->conn, $sql, [$idPos]);
            if ($stmt === false) return false;

            $rows = sqlsrv_rows_affected($stmt);
            return $rows !== false && $rows > 0;
        }
    }
?>
