<?php
    // /backend/procesos/Guardar_Info_Eliminado.php
    session_start();
    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../clases/InformeEliminado.php';
    require_once __DIR__ . '/../dao/InformeEliminadoDAO.php';

    date_default_timezone_set('America/Lima');

    /**
     * Convierte a MAYÚSCULAS con limpieza de espacios.
     * - Colapsa espacios múltiples a uno.
     * - Usa mb_strtoupper si está disponible (UTF-8; mantiene acentos).
     * - Recorta a longitud máxima con mb_substr si existe.
     * Si llega vacío tras limpiar, retorna null.
     */
    function to_upper_clean(?string $s, int $maxLen): ?string {
        if ($s === null) return null;
        $s = trim($s);
        if ($s === '') return null;
        $s = preg_replace('/\s+/u', ' ', $s);
        $s = function_exists('mb_strtoupper') ? mb_strtoupper($s, 'UTF-8') : strtoupper($s);
        if (function_exists('mb_substr')) $s = mb_substr($s, 0, $maxLen, 'UTF-8');
        else $s = substr($s, 0, $maxLen);
        return $s;
    }

    try {
        // Sesión
        if (!isset($_SESSION['id_usuario'])) {
            header('Location: ../../frontend/Login_LG.html?error=' . urlencode('Sesion expirada')); exit;
        }
        $idUsuario = $_SESSION['id_usuario'];

        // Solo POST
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Solicitud inválida') . '&tab=ielim'); exit;
        }

        // ===== Entradas =====
        // IDs que provienen de <select> (NO convertir a mayúsculas para no alterar llaves)
        $idEmpleado    = isset($_POST['ie_empleado'])    ? trim((string)$_POST['ie_empleado'])    : '';
        $idCategoria   = isset($_POST['ie_categoria'])   ? trim((string)$_POST['ie_categoria'])   : '';
        $idProducto    = isset($_POST['ie_producto'])    ? trim((string)$_POST['ie_producto'])    : '';
        $idResponsable = isset($_POST['ie_responsable']) ? trim((string)$_POST['ie_responsable']) : '';

        // Texto libre: motivo → MAYÚSCULAS
        $motivo = to_upper_clean($_POST['ie_motivo'] ?? null, 100); // CHECK de la tabla admite máx 100

        // Números (permitir coma o punto)
        // Unidades: aceptar "12", "12.0", "12,0" ⇒ 12
        $unidRaw  = $_POST['ie_unidades'] ?? '0';
        $unidades = (int)preg_replace('/[^\d-]+/', '', (string)$unidRaw);
        if ($unidades < 0) $unidades = 0;

        // Precio: "15,50" ⇒ 15.50
        $precio = isset($_POST['ie_precio']) ? (float)str_replace(',', '.', (string)$_POST['ie_precio']) : 0.0;
        if ($precio < 0) $precio = 0.0;

        // Total del formulario se ignora para seguridad; el DAO recalcula
        // $totalForm = isset($_POST['ie_total']) ? (float)str_replace(',', '.', $_POST['ie_total']) : null;

        // ===== Validaciones =====
        $motivosValidos = [
            'DEMORO MUCHO',
            'ERROR DEL CLIENTE',
            'CAMBIO DE PARECER EL HUESPED',
            'ERROR MOZO',
            'ERROR COCINA',
            'ERROR BAR',
            'NO LE GUSTO AL HUESPED',
            'CAMBIO COMPROBANTE',
            'PRUEBA',
            'FALTA DE INSUMOS',
        ];

        if ($idEmpleado === '' || $idCategoria === '' || $idProducto === '' || $idResponsable === '') {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Faltan datos requeridos') . '&tab=ielim'); exit;
        }
        if ($motivo === null || !in_array($motivo, $motivosValidos, true)) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Motivo no permitido') . '&tab=ielim'); exit;
        }

        // ===== Modelo (el DAO calculará TOTAL_MONTO_ELIMINADO = unidades * precio) =====
        $model = new InformeEliminado(
            null,           // ID (IDENTITY)
            null,           // FECHA (GETDATE())
            $idEmpleado,
            $idCategoria,
            $idProducto,
            $unidades,
            $precio,
            $motivo,
            null,           // TOTAL_MONTO_ELIMINADO (lo calcula el DAO)
            $idResponsable,
            $idUsuario
        );

        $dao = new InformeEliminadoDAO($conn);
        $ok  = $dao->insertar($model);

        header('Location: ../../frontend/app_Caja.php?' . ($ok ? 'ok=Eliminado+registrado' : 'err=No+se+pudo+registrar') . '&tab=ielim');
        exit;

    } catch (Throwable $e) {
        error_log('Guardar_Info_Eliminado: ' . $e->getMessage());
        header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Error interno') . '&tab=ielim'); exit;
    }
?>