<?php
    // /backend/procesos/Guardar_Nota_Credito.php
    session_start();

    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../clases/InformeNotaCredito.php';
    require_once __DIR__ . '/../dao/InformeNotaCreditoDAO.php';

    date_default_timezone_set('America/Lima');

    function to_upper_clean(?string $s, int $maxLen, bool $collapseSpaces = true): ?string {
        if ($s === null) return null;
        $s = trim($s);
        if ($s === '') return null;
        if ($collapseSpaces) {
            $s = preg_replace('/\s+/u', ' ', $s); // colapsa espacios
        }
        $s = function_exists('mb_strtoupper') ? mb_strtoupper($s, 'UTF-8') : strtoupper($s);
        if (function_exists('mb_substr')) {
            $s = mb_substr($s, 0, $maxLen, 'UTF-8');
        } else {
            $s = substr($s, 0, $maxLen);
        }
        return $s;
    }

    /**
     * Ref alfa-numérica: solo A–Z 0–9, MAYÚSCULA y máx 10.
     * Devuelve NULL si queda vacío.
     */
    function normalize_ref(?string $s): ?string {
        if ($s === null) return null;
        $s = preg_replace('/[^A-Za-z0-9]/', '', (string)$s); // solo AZ09
        $s = strtoupper($s);
        if ($s === '') return null;
        return substr($s, 0, 10);
    }

    try {
        if (!isset($_SESSION['id_usuario'])) {
            header('Location: ../../frontend/Login_LG.html?error=' . urlencode('Sesion expirada'));
            exit;
        }

        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: ../../frontend/app_Caja.php?tab=inota&err=' . urlencode('Solicitud inválida'));
            exit;
        }

        $idUsuario = $_SESSION['id_usuario'];

        // ===== Entradas =====
        $tipoRaw  = $_POST['nc_tipo']    ?? '';
        $refARaw  = $_POST['nc_ref_anu'] ?? null;
        $refCRaw  = $_POST['nc_ref_cor'] ?? null;
        $itemsRaw = $_POST['nc_items']   ?? 0;
        $montoRaw = $_POST['nc_monto']   ?? 0;
        $motivoRaw= $_POST['nc_motivo']  ?? '';

        // ===== Normalizaciones/validaciones =====
        // Tipo permitido
        $tipo = strtoupper(trim((string)$tipoRaw));
        $permitidos = ['BOLETA','FUNCIONARIO','FACTURA'];
        if (!in_array($tipo, $permitidos, true)) {
            header('Location: ../../frontend/app_Caja.php?tab=inota&err=' . urlencode('Tipo de documento inválido'));
            exit;
        }

        // Refs
        $refA = normalize_ref($refARaw); // puede quedar NULL
        $refC = normalize_ref($refCRaw); // puede quedar NULL

        // Cantidad items
        $items = is_numeric($itemsRaw) ? (int)$itemsRaw : 0;
        if ($items < 0) $items = 0;

        // Monto (coma o punto)
        $monto = (float)str_replace(',', '.', (string)$montoRaw);
        if ($monto < 0) $monto = 0.0;

        // Motivo a MAYÚSCULA, máx 200
        $motivo = to_upper_clean($motivoRaw, 200);
        if (!$motivo) {
            header('Location: ../../frontend/app_Caja.php?tab=inota&err=' . urlencode('Ingrese el motivo'));
            exit;
        }

        // ===== Modelo =====
        $nota = new InformeNotaCredito(
            null,     // ID autoincremental
            null,     // FECHA_REG (DEFAULT GETDATE())
            $tipo,
            $refA,
            $refC,
            $items,
            $monto,   // el DAO lo redondea al paso (0.10 por defecto)
            $motivo,
            $idUsuario
        );

        // ===== DAO =====
        $dao = new InformeNotaCreditoDAO($conn);
        // Si quisieras cambiar el paso de redondeo:
        // $dao->setPasoRedondeoMonto(0.10);
        $ok = $dao->insertar($nota);

        $dest = '../../frontend/app_Caja.php?tab=inota';
        if ($ok) {
            header('Location: ' . $dest . '&ok=' . urlencode('Nota de crédito registrada'));
        } else {
            header('Location: ' . $dest . '&err=' . urlencode('No se pudo registrar la nota de crédito'));
        }
        exit;

    } catch (Throwable $e) {
        error_log('Guardar_Nota_Credito: ' . $e->getMessage());
        header('Location: ../../frontend/app_Caja.php?tab=inota&err=' . urlencode('Error interno'));
        exit;
    }
?>