<?php
    // /backend/procesos/Guardar_Reporte_Pos.php
    session_start();

    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../clases/ReportePos.php';
    require_once __DIR__ . '/../dao/ReportePosDAO.php';

    date_default_timezone_set('America/Lima');

    if ($_SERVER["REQUEST_METHOD"] === "POST") {

        // 1) Validar sesión
        if (!isset($_SESSION['id_usuario'])) {
            header('Location: ../../frontend/Login_LB.html?error=' . urlencode('Sesion expirada'));
            exit;
        }

        // 2) Leer POST (se admiten alias de nombres para flexibilidad del formulario)
        //    Ajusta estos nombres a los de tu <form> si ya los tienes definidos
        $idPos   = $_POST['rp_pos']   ?? $_POST['id_pos']   ?? '';
        $cant    = $_POST['rp_cant']  ?? $_POST['cant']     ?? $_POST['cant_cobros_pos'] ?? '';
        $monto   = $_POST['rp_monto'] ?? $_POST['monto']    ?? $_POST['mon_pos'] ?? '';

        $idPos   = trim((string)$idPos);
        $cant    = is_numeric($cant)  ? (int)$cant  : null;
        $monto   = is_numeric($monto) ? (float)$monto : null;

        $idUsuario = $_SESSION['id_usuario'];

        // 3) Validaciones
        $errores = [];

        // ID_POS: DECIMAL(10,0) -> solo dígitos, hasta 10
        if ($idPos === '' || !preg_match('/^\d{1,10}$/', $idPos)) {
            $errores[] = 'ID POS inválido (solo dígitos y máx. 10).';
        }

        if ($cant === null || $cant < 0) {
            $errores[] = 'Cantidad de cobros inválida.';
        }

        if ($monto === null || $monto < 0) {
            $errores[] = 'Monto POS inválido.';
        }

        if (!empty($errores)) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode(implode(' ', $errores)));
            exit;
        }

        // 4) Construir objeto de dominio
        $rep = new ReportePos(
            null,             // IDENTITY (lo genera SQL)
            null,             // FECHA (DEFAULT GETDATE())
            $idPos,           // ID_POS (string de dígitos)
            (int)$cant,       // CANT_COBROS_POS
            (float)$monto,    // MON_POS
            $idUsuario        // ID_USUARIO (FK)
        );

        // 5) Guardar con DAO
        $dao = new ReportePosDAO($conn);
        $ok  = $dao->insertar($rep);

        if ($ok) {
            header('Location: ../../frontend/app_Caja.php?ok=' . urlencode('Reporte POS registrado') . '&tab=rpos');
            exit;
        } else {
            echo "Error al registrar Reporte POS.<br>";
            if ($e = sqlsrv_errors()) {
                echo "<pre>"; print_r($e); echo "</pre>";
            }
            exit;
        }
    }
?>