<?php
    // /backend/procesos/Insertar_Cierre_Caja.php
    session_start();
    header('Content-Type: application/json; charset=utf-8');

    try {
        if (!isset($_SESSION['id_usuario'])) {
            echo json_encode(['ok'=>false,'error'=>'Sesión expirada']); exit;
        }
        if (($_SESSION['rol'] ?? '') !== 'ADMIN') {
            echo json_encode(['ok'=>false,'error'=>'Sin permiso']); exit;
        }

        $conteo = isset($_POST['conteo']) ? (float)$_POST['conteo'] : null;
        if ($conteo === null || $conteo < 0) {
            echo json_encode(['ok'=>false,'error'=>'Conteo físico inválido']); exit;
        }

        $idUsuario = $_SESSION['id_usuario'];

        // 📦 CONEXIÓN A BD (tu archivo original, NO SE MODIFICA)
        require_once __DIR__ . '/../database/conexion_sql_server.php';

        // 📦 DAO y dependencias
        require_once __DIR__ . '/../dao/InformeCierreCajaDAO.php';
        require_once __DIR__ . '/../../vendor/autoload.php';

        // Validación de conexión
        if (!$conn) { throw new RuntimeException('Error: conexión SQL falló.'); }

        $dao = new InformeCierreCajaDAO($conn);
        $obj = $dao->buildCierreHoy($idUsuario, $conteo);
        $id  = $dao->insert($obj);

        // ✅ RESPUESTA CORRECTA
        echo json_encode(['ok'=>true, 'id'=>$id], JSON_UNESCAPED_UNICODE);
        exit;

    } catch (Throwable $e) {
        // ❌ RESPUESTA DE ERROR
        echo json_encode(['ok'=>false, 'error'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
        exit;
    }
?>