<?php
    session_start();
    require_once __DIR__ . "/../database/Conexion_SQL_Server.php";
    require_once __DIR__ . "/../dao/ListaEsperaDAO.php";

    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $nombreCliente = isset($_POST['nombre_cliente']) ? trim($_POST['nombre_cliente']) : '';
        $estado        = isset($_POST['estado']) ? trim($_POST['estado']) : '';

        if ($nombreCliente !== '' && $estado !== '') {
            $dao = new RegistroListaDAO($conn);
            $ok  = $dao->actualizarEstadoPorNombre($nombreCliente, $estado);

            if ($ok) {
                // ✅ Estado actualizado correctamente
                header('Location: ./Select_ListaEspera.php?ok=1');
                exit;
            } else {
                // ⚠️ Error al actualizar (nombre no existe o estado inválido)
                header('Location: ./Select_ListaEspera.php?error=update');
                exit;
            }
        } else {
            // ⚠️ Faltan parámetros
            header('Location: ./Select_ListaEspera.php?error=params');
            exit;
        }
    } else {
        // ⚠️ Si entran directo sin POST
        header('Location: ./Select_ListaEspera.php');
        exit;
    }
?>