<?php
    // =========================================================
    // Ejecutar importar_excel_guardiana.py
    // Origen: C:\xampp\htdocs\Proyecto_Guardiana\excels\<archivo>
    // Destino fijo: E:\Archivo_LG_Cierre_Caja.xlsx
    // =========================================================
    header('Content-Type: application/json; charset=utf-8');
    date_default_timezone_set('America/Lima');

    // --- Configuración ---
    $PYTHON_BIN = 'C:\\Users\\Acer\\AppData\\Local\\Programs\\Python\\Python313\\python.exe'; // ajusta si usas otra versión/venv
    $PY_SCRIPT  = realpath(__DIR__ . '/../python_scripts/importar_excel_guardiana.py');

    $EXCEL_DIR       = realpath(__DIR__ . '/../../excels'); // carpeta con archivos desordenados
    $ARCHIVO_DESTINO = 'E:\\Archivo_LG_Cierre_Caja.xlsx';   // destino FIX

    // --- Validaciones base ---
    if (!file_exists($PYTHON_BIN)) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>"Python no encontrado en: $PYTHON_BIN"]);
    exit;
    }
    if ($PY_SCRIPT === false || !file_exists($PY_SCRIPT)) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>"Script Python no encontrado en backend/python_scripts/importar_excel_guardiana.py"]);
    exit;
    }
    if ($EXCEL_DIR === false || !is_dir($EXCEL_DIR)) {
    http_response_code(500);
    echo json_encode(['ok'=>false,'error'=>"No existe la carpeta de excels: /excels"]);
    exit;
    }
    if (!file_exists($ARCHIVO_DESTINO)) {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>"No existe el archivo destino: $ARCHIVO_DESTINO"]);
    exit;
    }

    // --- Solo POST ---
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['ok'=>false,'error'=>'Usa método POST']);
    exit;
    }

    // --- Parámetros: nombre de archivo origen dentro de /excels + hoja_destino ---
    $origen_nombre = trim($_POST['origen_nombre'] ?? '');
    $hoja_destino  = trim($_POST['hoja_destino'] ?? 'IMPORTACION_ORACLE_LG');

    if ($origen_nombre === '') {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>'Indica "origen_nombre" (ej. ventas_2025_10_09.xlsx)']);
    exit;
    }

    // Seguridad básica: impedir rutas fuera de /excels
    $origen_nombre = basename($origen_nombre);
    $ext = strtolower(pathinfo($origen_nombre, PATHINFO_EXTENSION));
    if (!in_array($ext, ['xlsx','xls'])) {
    http_response_code(400);
    echo json_encode(['ok'=>false,'error'=>'El origen debe ser .xlsx o .xls']);
    exit;
    }

    $ORIGEN_PATH = $EXCEL_DIR . DIRECTORY_SEPARATOR . $origen_nombre;
    if (!file_exists($ORIGEN_PATH)) {
    http_response_code(404);
    echo json_encode(['ok'=>false,'error'=>"No existe el archivo origen seleccionado: $ORIGEN_PATH"]);
    exit;
    }
    if ($hoja_destino === '') {
    $hoja_destino = 'IMPORTACION_ORACLE_LG';
    }

    // --- Ejecutar Python (forzando UTF-8 y filtrando warnings) ---
    putenv('PYTHONIOENCODING=UTF-8');
    putenv('PYTHONUTF8=1');

    $cmd = escapeshellcmd($PYTHON_BIN)
        . ' -X utf8 '
        . escapeshellarg($PY_SCRIPT) . ' '
        . escapeshellarg($ORIGEN_PATH) . ' '
        . escapeshellarg($ARCHIVO_DESTINO) . ' '
        . escapeshellarg($hoja_destino)
        . ' 2>&1';

    $output = [];
    $code   = 0;
    exec($cmd, $output, $code);

    // Filtrar warning inocuo de openpyxl
    $filtered = array_values(array_filter($output, function($line){
    // Quita el warning "Workbook contains no default style..."
    return (stripos($line, 'openpyxl') === false || stripos($line, 'no default style') === false);
    }));

    if ($code !== 0) {
    http_response_code(500);
    echo json_encode([
        'ok'=>false,
        'error'=>"Python devolvió código $code",
        'salida'=>$filtered
    ], JSON_UNESCAPED_UNICODE);
    exit;
    }

    // --- OK ---
    echo json_encode([
    'ok' => true,
    'msg' => implode("\n", $filtered),
    'paths' => [
        'origen_usado'               => $ORIGEN_PATH,
        'archivo_destino_actualizado'=> $ARCHIVO_DESTINO
    ]
    ], JSON_UNESCAPED_UNICODE);
?>