<?php
  session_start();

  // Verifica si hay sesión iniciada
  if (!isset($_SESSION['id_usuario'])) {
      header('Location: Login_LB.html?error=Sesion expirada');
      exit;
  }

  // Verifica que el rol sea 'RECEPCION'
  if (($_SESSION['rol'] ?? '') !== 'RECEPCION') {
      header('Location: home.php?error=sin_permiso');
      exit;
  }

  // Obtener variables de sesión
  $idUsuario = $_SESSION['id_usuario'];
  $rol       = $_SESSION['rol'] ?? '';
  $estado    = $_SESSION['estado'] ?? '';
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8" />
    <title>Registro en Lista de Espera</title>

    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet" />
    <!-- Google Fonts (Inter) -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600&display=swap" rel="stylesheet" />

    <link rel="stylesheet" href="../css/Estilos_appRecepcion.css">
</head>
<body>

  <header>
    <div class="d-flex align-items-center gap-2">
      <i class="bi bi-person-circle icono-usuario"></i>
      <div>
        <strong><?php echo htmlspecialchars($idUsuario, ENT_QUOTES, 'UTF-8'); ?></strong><br />
        <small><?php echo htmlspecialchars($rol, ENT_QUOTES, 'UTF-8'); ?></small>
      </div>
    </div>
    
    <!-- Botón cerrar sesión (versión simple con confirm) -->
    <form action="../backend/procesos/seguridad/logout.php"
          method="post"
          class="m-0"
          onsubmit="return confirm('¿Deseas cerrar sesión?');">
      <button type="submit" class="btn btn-logout">
        <i class="bi bi-box-arrow-right"></i> Cerrar sesión
      </button>
    </form>


  </header>

  
  <div class="bg-overlay"></div>

  <div class="container">
    <div class="form-card">
      <h2>Registro en Lista de Espera</h2>

      <form action="../backend/procesos/Guardar_ListaEspera.php" method="post" class="row g-3">

        <div class="col-12">
          <label for="nombre">Nombre completo</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-person-fill"></i></span>
            <input type="text" id="nombre" name="nombre" class="form-control" placeholder="Juan Pérez" required />
          </div>
        </div>

        <div class="col-12">
          <label for="telefono">Teléfono del cliente</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-telephone-fill"></i></span>
            <input
              type="tel"
              id="telefono"
              name="telefono"
              class="form-control"
              pattern="[0-9]{8,15}"
              inputmode="numeric"
              placeholder="Ej: 8291234567"
            />
          </div>
        </div>

        <div class="col-6">
          <label for="adultos">Cantidad de adultos</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-people-fill"></i></span>
            <input type="number" id="adultos" name="adultos" class="form-control" min="0" required>
          </div>
        </div>

        <div class="col-6">
          <label for="ninos">Cantidad de niños</label>
          <div class="input-group">
            <span class="input-group-text"><i class="bi bi-baby-fill"></i></span>
            <input type="number" id="ninos" name="ninos" class="form-control" min="0">
          </div>
        </div>


        <div class="col-12">
          <label for="estado">Estado del registro</label>
          <select id="estado" name="estado" class="form-select" required>
            <option value="EN ESPERA">EN ESPERA</option>
          </select>
        </div>

        <div class="col-12 d-grid gap-3 mt-4">
          <button type="submit" class="btn btn-primary btn-lg">Agregar a la lista</button>
          <a href="/Proyecto_Guardiana/backend/procesos/Select_ListaEspera.php" class="btn btn-success btn-lg text-center">Ver lista</a>
        </div>
      </form>
    </div>
  </div>

  <!-- Bootstrap JS Bundle -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>