<?php session_start(); ?>
<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <title>Lista de Alumnos</title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="/Proyecto_Guardiana/css/Estilos_appRecepcion_Listado.css?v=1">
</head>

<body class="bg-light">
    <div class="container py-4">

        <!-- Encabezado -->
        <div class="page-header mb-3">
            <h1 class="page-title h3">Clientes Registrados</h1>
            <div class="d-flex gap-2">
                <a href="/Proyecto_Guardiana/frontend/app_Recepcion.php" class="btn btn-primary">+ Nuevo Cliente</a>
                <form action="/Proyecto_Guardiana/backend/procesos/export/Exportar_ListaEspera.php" method="post">
                    <button type="submit" class="btn btn-success">Exportar a Excel</button>
                </form>
            </div>
        </div>

        <!-- Mensaje de confirmación -->
        <?php if(isset($_GET['ok'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            Cliente guardado correctamente ✅
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Cerrar"></button>
        </div>
        <?php endif; ?>
        
       
        <!-- Bloque para modificar estado -->
        <div class="card estado-card shadow-sm mb-4">
            <div class="card-body">
                <h5 class="card-title text-center mb-3">MODIFICAR ESTADO DEL CLIENTE</h5>
                <form action="../procesos/Update_ListaEspera.php" method="post" class="row g-3 justify-content-center">

                    <!-- Combo de clientes -->
                    <div class="col-md-5">
                        <label class="form-label">Nombre del Cliente</label>
                        <select name="nombre_cliente" class="form-select" required>
                            <option value="">-- Seleccione un cliente --</option>
                            <?php foreach($alumnos as $alumno): ?>
                            <?php if ($alumno['ESTADO_REGISTRO'] === 'EN ESPERA'): ?>
                            <option value="<?= htmlspecialchars($alumno['NOMBRE_COMPLETO'], ENT_QUOTES, 'UTF-8'); ?>">
                                <?= htmlspecialchars($alumno['NOMBRE_COMPLETO'], ENT_QUOTES, 'UTF-8'); ?>
                            </option>
                            <?php endif; ?>
                            <?php endforeach; ?>
                        </select>
                    </div>


                    <!-- Estados -->
                    <div class="col-md-3">
                        <label class="form-label">Estado</label>
                        <select name="estado" class="form-select" required>
                            <option value="LLAMADO">LLAMADO</option>
                            <option value="CANCELADO">CANCELADO</option>
                        </select>
                    </div>

                    <!-- Botón -->
                    <div class="col-12 text-center">
                        <button type="submit" class="btn btn-dark btn-lg">ACTUALIZAR</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Tabla -->
        <div class="card shadow-sm rounded-3">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-primary text-center">
                        <tr>
                            <th>ID</th>
                            <th>Fecha Registro</th>
                            <th>Nombre Completo</th>
                            <th>Teléfono</th>
                            <th>Adultos</th>
                            <th>Niños</th>
                            <th>Estado</th>
                            <th>Fecha Recepción</th>
                            <th>Observacion</th>
                        </tr>
                    </thead>
                    <tbody class="text-center">
                        <?php foreach($alumnos as $alumno): ?>
                        <tr>
                            <td>
                                <?= (int)$alumno['ID_ORDER']; ?>
                            </td>
                            <td>
                                <?php
                    $fr = $alumno['FECHA_REGISTRO'];
                    echo $fr instanceof DateTime ? $fr->format('Y-m-d H:i:s') : htmlspecialchars((string)$fr, ENT_QUOTES, 'UTF-8');
                  ?>
                            </td>
                            <td>
                                <?= htmlspecialchars($alumno['NOMBRE_COMPLETO'], ENT_QUOTES, 'UTF-8'); ?>
                            </td>
                            <td>
                                <?= htmlspecialchars($alumno['TELEFONO_CLIENTE'], ENT_QUOTES, 'UTF-8'); ?>
                            </td>
                            <td>
                                <?= (int)$alumno['CANTIDAD_ADULTOS']; ?>
                            </td>
                            <td>
                                <?= (int)$alumno['CANTIDAD_NINOS']; ?>
                            </td>
                            <td>
                                <?php
                    $estado = (string)$alumno['ESTADO_REGISTRO'];
                    $badge = 'secondary';
                    if ($estado === 'EN ESPERA') $badge = 'warning';
                    if ($estado === 'LLAMADO')   $badge = 'success';
                    if ($estado === 'CANCELADO') $badge = 'danger';
                  ?>
                                <span class="badge text-bg-<?= $badge ?>">
                                    <?= htmlspecialchars($estado, ENT_QUOTES, 'UTF-8') ?>
                                </span>
                            </td>
                            <td>
                                <?php
                    $frc = $alumno['FECHA_RECEPCION'];
                    echo $frc instanceof DateTime ? $frc->format('Y-m-d H:i:s') : htmlspecialchars((string)$frc, ENT_QUOTES, 'UTF-8');
                  ?>
                            </td>
                            <td>
                                <?= htmlspecialchars((string)$alumno['OBSERVACION'], ENT_QUOTES, 'UTF-8'); ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>

    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <!-- SweetAlert2 (popup) -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <?php
    // Si el exportador dejó un "flash" en sesión:
    $flash = $_SESSION['flash_export'] ?? null;
    if ($flash) {
        unset($_SESSION['flash_export']); // se muestra una sola vez
        $type = $flash['type']; // success | warning | danger | info
        $text = $flash['text'] ?? '';

        // icono/título según tipo
        $icon = ($type === 'danger') ? 'error' :
                (($type === 'warning') ? 'warning' :
                (($type === 'success') ? 'success' : 'info'));
        $title = ($type === 'danger') ? 'Error' :
                (($type === 'warning') ? 'Aviso' :
                (($type === 'success') ? '¡Listo!' : 'Información'));

        // escapar texto
        $safeText  = htmlspecialchars($text, ENT_QUOTES, 'UTF-8');
        $safeTitle = htmlspecialchars($title, ENT_QUOTES, 'UTF-8');
        $safeIcon  = htmlspecialchars($icon, ENT_QUOTES, 'UTF-8');
    ?>
    <script>
    document.addEventListener('DOMContentLoaded', function () {
    Swal.fire({
        icon: '<?= $safeIcon ?>',
        title: '<?= $safeTitle ?>',
        text: '<?= $safeText ?>',
        confirmButtonText: 'OK'
    });
    });
    </script>
    <?php } ?>

</body>

</html>