<?php
    class ReportePos {
        private $idReportePos;     // INT IDENTITY
        private $fechaRegPos;      // DATETIME (DEFAULT GETDATE())
        private $idPos;            // FK -> POS(ID_POS)
        private $cantCobrosPos;    // INT
        private $monPos;           // DECIMAL(10,2)
        private $idUsuario;        // FK -> USUARIO(ID_USUARIO)

        // Constructor (id y fecha son opcionales porque los genera SQL Server)
        public function __construct(
            ?int $idReportePos = null,
            ?string $fechaRegPos = null,
            string $idPos = '',
            int $cantCobrosPos = 0,
            float $monPos = 0.0,
            string $idUsuario = ''
        ) {
            $this->idReportePos  = $idReportePos;
            $this->fechaRegPos   = $fechaRegPos; // puede venir como string 'Y-m-d H:i:s'
            $this->idPos         = $idPos;
            $this->cantCobrosPos = $cantCobrosPos;
            $this->monPos        = $monPos;
            $this->idUsuario     = $idUsuario;
        }

        // ====== Getters y Setters ======

        public function getIdReportePos(): ?int {
            return $this->idReportePos;
        }

        public function setIdReportePos(?int $idReportePos): void {
            $this->idReportePos = $idReportePos;
        }

        public function getFechaRegPos(): ?string {
            return $this->fechaRegPos;
        }

        public function setFechaRegPos(?string $fechaRegPos): void {
            $this->fechaRegPos = $fechaRegPos;
        }

        public function getIdPos(): string {
            return $this->idPos;
        }

        public function setIdPos(string $idPos): void {
            $this->idPos = $idPos;
        }

        public function getCantCobrosPos(): int {
            return $this->cantCobrosPos;
        }

        public function setCantCobrosPos(int $cantCobrosPos): void {
            $this->cantCobrosPos = $cantCobrosPos;
        }

        public function getMonPos(): float {
            return $this->monPos;
        }

        public function setMonPos(float $monPos): void {
            $this->monPos = $monPos;
        }

        public function getIdUsuario(): string {
            return $this->idUsuario;
        }

        public function setIdUsuario(string $idUsuario): void {
            $this->idUsuario = $idUsuario;
        }
    }
?>
