<?php
    require_once __DIR__ . '/../clases/Empleado.php';

    class EmpleadoDAO {
        private $conn;

        // Recibe la conexión ya creada (como tu ejemplo)
        public function __construct($conn) {
            $this->conn = $conn;
        }

        // INSERTAR
        public function insertar(Empleado $emp): bool {
            $sql = "INSERT INTO EMPLEADO 
                    (ID_EMPLEADO, NOMBRE_EMPLEADO, APELLIDO_EMPLEADO, LOCAL_EMPLEADO, AREA_EMPLEADO, ESTADO_EMPLEADO)
                    VALUES (?, ?, ?, ?, ?, ?)";

            $params = [
                $emp->getIdEmpleado(),
                $emp->getNombreEmpleado(),
                $emp->getApellidoEmpleado(),
                $emp->getLocalEmpleado(),
                $emp->getAreaEmpleado(),
                $emp->getEstadoEmpleado()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // LISTAR (opcionalmente solo activos/inactivos). Devuelve arrays asociativos
        public function listarTodos(?string $soloEstado = null): array {
            $sql = "SELECT 
                        ID_EMPLEADO,
                        NOMBRE_EMPLEADO,
                        APELLIDO_EMPLEADO,
                        LOCAL_EMPLEADO,
                        AREA_EMPLEADO,
                        ESTADO_EMPLEADO
                    FROM EMPLEADO";
            $params = [];

            if ($soloEstado !== null) {
                $sql .= " WHERE ESTADO_EMPLEADO = ?";
                $params[] = strtoupper(trim($soloEstado));
            }

            $sql .= " ORDER BY APELLIDO_EMPLEADO, NOMBRE_EMPLEADO";

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            if ($stmt === false) return [];

            $rows = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                $rows[] = $row;
            }
            return $rows;
        }

        // BUSCAR POR ID. Devuelve array o null
        public function buscarPorId(string $idEmpleado): ?array {
            $sql = "SELECT 
                        ID_EMPLEADO,
                        NOMBRE_EMPLEADO,
                        APELLIDO_EMPLEADO,
                        LOCAL_EMPLEADO,
                        AREA_EMPLEADO,
                        ESTADO_EMPLEADO
                    FROM EMPLEADO
                    WHERE ID_EMPLEADO = ?";
            $stmt = sqlsrv_query($this->conn, $sql, [$idEmpleado]);
            if ($stmt === false) return null;

            $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
            return $row ?: null;
        }

        // ACTUALIZAR (por ID)
        public function actualizar(Empleado $emp): bool {
            $sql = "UPDATE EMPLEADO
                    SET NOMBRE_EMPLEADO  = ?,
                        APELLIDO_EMPLEADO = ?,
                        LOCAL_EMPLEADO    = ?,
                        AREA_EMPLEADO     = ?,
                        ESTADO_EMPLEADO   = ?
                    WHERE ID_EMPLEADO    = ?";

            $params = [
                $emp->getNombreEmpleado(),
                $emp->getApellidoEmpleado(),
                $emp->getLocalEmpleado(),
                $emp->getAreaEmpleado(),
                $emp->getEstadoEmpleado(),
                $emp->getIdEmpleado()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            if ($stmt === false) return false;

            $rows = sqlsrv_rows_affected($stmt);
            return $rows !== false && $rows > 0;
        }

        
    }
?>