<?php
    require_once __DIR__ . '/../clases/ListaEspera.php';

    class RegistroListaDAO {
        private $conn;

        public function __construct($conn) {
            $this->conn = $conn;
        }

        // Insertar un registro
        public function insertar(RegistroLista $registro) {
            $sql = "INSERT INTO REGISTRO_LISTA 
                    (NOMBRE_COMPLETO, TELEFONO_CLIENTE, CANTIDAD_ADULTOS, [CANTIDAD_NIÑOS], ESTADO_REGISTRO, FECHA_RECEPCION, OBSERVACION)
                    VALUES (?, ?, ?, ?, ?, null, null)";

            $params = [
                $registro->getNombreCompleto(),
                $registro->getTelefonoCliente(),
                $registro->getCantidadAdultos(),
                $registro->getCantidadNinos(),
                $registro->getEstadoRegistro(),
                $registro->getObservacion()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // Listar registros -> DEVOLVER ARRAYS
        public function listarTodos() { 
            $sql = "SELECT 
                        ID_ORDER, 
                        FECHA_REGISTRO, 
                        NOMBRE_COMPLETO, 
                        TELEFONO_CLIENTE, 
                        CANTIDAD_ADULTOS, 
                        [CANTIDAD_NIÑOS] AS CANTIDAD_NINOS, 
                        ESTADO_REGISTRO, 
                        FECHA_RECEPCION, 
                        OBSERVACION
                    FROM REGISTRO_LISTA
                    WHERE CONVERT(date, FECHA_REGISTRO) = CONVERT(date, GETDATE())
                    ORDER BY ID_ORDER DESC";
            $stmt = sqlsrv_query($this->conn, $sql);

            if ($stmt === false) {
                return [];
            }

            $registros = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                $registros[] = $row;
            }
            return $registros;
        }

        // ✅ Actualizar estado por NOMBRE_COMPLETO (solo LLAMADO o CANCELADO)
        public function actualizarEstadoPorNombre(string $nombre, string $estado) {
            $estado = strtoupper(trim($estado));
            if (!in_array($estado, ['LLAMADO','CANCELADO'], true)) {
                return false;
            }

            if ($estado === 'LLAMADO') {
                $sql = "
                    UPDATE RL
                    SET RL.ESTADO_REGISTRO = ?,
                        RL.FECHA_RECEPCION  = GETDATE(),
                        RL.OBSERVACION      = 'EL CLIENTE INGRESO CON EXITO'
                    FROM REGISTRO_LISTA RL
                    WHERE RL.ID_ORDER = (
                            SELECT TOP(1) ID_ORDER
                            FROM REGISTRO_LISTA
                            WHERE NOMBRE_COMPLETO = ?

                    )";
                $params = [$estado, $nombre];
            } else {
                $sql = "
                    UPDATE RL
                    SET RL.ESTADO_REGISTRO = ?,
                        RL.FECHA_RECEPCION  = GETDATE(),
                        RL.OBSERVACION      = 'EL CLIENTE CANCELO'
                    FROM REGISTRO_LISTA RL
                    WHERE RL.ID_ORDER = (
                            SELECT TOP(1) ID_ORDER
                            FROM REGISTRO_LISTA
                            WHERE NOMBRE_COMPLETO = ?

                    )";
                $params = [$estado, $nombre];
            }

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            if ($stmt === false) return false;

            $rows = sqlsrv_rows_affected($stmt);
            return $rows !== false && $rows > 0;
        }
    }
?>