<?php
    require_once __DIR__ . '/../clases/PropinaFisico.php';

    class PropinaFisicoDAO {
        private $conn;

        public function __construct($conn) {
            $this->conn = $conn;
        }

        // Insertar un registro
        public function insertar(PropinaFisico $propina) {
            $sql = "INSERT INTO PROPINA_FISICO 
                    (ID_EMPLEADO, MONTO_PROP_FISICO, ID_USUARIO)
                    VALUES (?, ?, ?)";

            $params = [
                $propina->getIdEmpleado(),
                $propina->getMontoPropFisico(),
                $propina->getIdUsuario()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // Listar registros -> DEVOLVER ARRAYS
        public function listarTodos() { 
            $sql = "SELECT 
                        ID_PROP_FISICO, 
                        FECHA_REG_FISICO, 
                        ID_EMPLEADO, 
                        MONTO_PROP_FISICO, 
                        ID_USUARIO
                    FROM PROPINA_FISICO
                    WHERE CONVERT(date, FECHA_REG_FISICO) = CONVERT(date, GETDATE())
                    ORDER BY ID_PROP_FISICO DESC";
            $stmt = sqlsrv_query($this->conn, $sql);

            if ($stmt === false) {
                return [];
            }

            $propinas = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                $propinas[] = $row;
            }
            return $propinas;
        }
    }








?>