<?php
    // Ubicación sugerida: /backend/dao/PropinaTarjetaDAO.php
    require_once __DIR__ . '/../clases/PropinaTarjeta.php';

    class PropinaTarjetaDAO {
        private $conn;

        public function __construct($conn) {
            $this->conn = $conn;
        }

        // Insertar un registro (true/false)
        public function insertar(PropinaTarjeta $propina) {
            $sql = "INSERT INTO PROPINA_TARJETA
                    (ID_PROP_REFF, ID_EMPLEADO, MON_TARJETA, DESC_MON_TARJETA, ID_USUARIO)
                    VALUES (?, ?, ?, ?, ?)";

            $params = [
                $propina->getIdPropReff(),
                $propina->getIdEmpleado(),
                $propina->getMonTarjeta(),
                $propina->getDescMonTarjeta(),
                $propina->getIdUsuario()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // Listar registros del DÍA ACTUAL (devuelve arrays)
        public function listarTodos() {
            $sql = "SELECT
                        ID_PROPINA_TARJETA,
                        FECHA_REG_TARJETA,
                        ID_PROP_REFF,
                        ID_EMPLEADO,
                        MON_TARJETA,
                        DESC_MON_TARJETA,
                        ID_USUARIO
                    FROM PROPINA_TARJETA
                    WHERE CONVERT(date, FECHA_REG_TARJETA) = CONVERT(date, GETDATE())
                    ORDER BY ID_PROPINA_TARJETA DESC";

            $stmt = sqlsrv_query($this->conn, $sql);
            if ($stmt === false) {
                return [];
            }

            $rows = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                // Normaliza fecha si viene como DateTime de sqlsrv
                if (isset($row['FECHA_REG_TARJETA']) && $row['FECHA_REG_TARJETA'] instanceof DateTime) {
                    $row['FECHA_REG_TARJETA'] = $row['FECHA_REG_TARJETA']->format('Y-m-d H:i:s');
                }
                $rows[] = $row;
            }
            return $rows;
        }
    }
?>
