<?php
    // Ubicación sugerida: /backend/dao/ReportePosDAO.php
    require_once __DIR__ . '/../clases/ReportePos.php';

    class ReportePosDAO {
        private $conn;

        public function __construct($conn) {
            $this->conn = $conn;
        }

        // Insertar un registro (true/false)
        public function insertar(ReportePos $rep) {
            $sql = "INSERT INTO REPORTE_POS
                    (ID_POS, CANT_COBROS_POS, MON_POS, ID_USUARIO)
                    VALUES (?, ?, ?, ?)";

            // ID_POS en BD es DECIMAL(10,0) -> lo mandamos como int para el FK a POS
            $params = [
                (int)$rep->getIdPos(),
                $rep->getCantCobrosPos(),
                $rep->getMonPos(),
                $rep->getIdUsuario()
            ];

            $stmt = sqlsrv_query($this->conn, $sql, $params);
            return $stmt !== false;
        }

        // Listar registros del DÍA ACTUAL (arrays asociativos)
        public function listarTodos() {
            $sql = "SELECT
                        ID_REPORTE_POS,
                        FECHA_REG_POS,
                        ID_POS,
                        CANT_COBROS_POS,
                        MON_POS,
                        ID_USUARIO
                    FROM REPORTE_POS
                    WHERE CONVERT(date, FECHA_REG_POS) = CONVERT(date, GETDATE())
                    ORDER BY ID_REPORTE_POS DESC";

            $stmt = sqlsrv_query($this->conn, $sql);
            if ($stmt === false) {
                return [];
            }

            $rows = [];
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                // Normaliza fecha si viene como DateTime de sqlsrv
                if (isset($row['FECHA_REG_POS']) && $row['FECHA_REG_POS'] instanceof DateTime) {
                    $row['FECHA_REG_POS'] = $row['FECHA_REG_POS']->format('Y-m-d H:i:s');
                }
                // Normaliza ID_POS (puede venir numérico); lo dejamos como string
                if (isset($row['ID_POS'])) {
                    $row['ID_POS'] = (string)$row['ID_POS'];
                }
                $rows[] = $row;
            }
            return $rows;
        }
    }
?>