<?php
    require_once __DIR__ . '/../clases/Usuario.php';

    class UsuarioDAO {
        private $conn;
        public function __construct($conn) { $this->conn = $conn; }

        public function obtenerPorId($idUsuario) {
            $sql = "SELECT ID_USUARIO, CONTRASENA, ROL, ESTADO_USUARIO
                    FROM USUARIO WHERE ID_USUARIO = ?";
            $stmt = sqlsrv_query($this->conn, $sql, [$idUsuario]);
            if ($stmt === false) { throw new Exception(print_r(sqlsrv_errors(), true)); }
            $row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);
            if (!$row) return null;

            return new Usuario($row['ID_USUARIO'], $row['CONTRASENA'], $row['ROL'], $row['ESTADO_USUARIO']);
        }

        public function validarCredenciales($idUsuario, $contrasenaPlano) {
            $u = $this->obtenerPorId($idUsuario);
            if ($u === null) return [false, null, "Usuario no existe"];
            if (strtoupper($u->getEstadoUsuario()) !== 'ACTIVO') return [false, null, "Usuario inactivo"];
            if ($contrasenaPlano !== $u->getContrasena()) return [false, null, "Contraseña incorrecta"];
            return [true, $u, null];
        }
    }
?>