<?php
    // /backend/procesos/Guardar_Informe_Cortesia.php
    session_start();
    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../clases/InformeCortesia.php';
    require_once __DIR__ . '/../dao/InformeCortesiaDAO.php';

    date_default_timezone_set('America/Lima');

    /**
     * Convierte a MAYÚSCULAS con limpieza de espacios.
     * - Colapsa espacios múltiples a uno.
     * - Usa mb_strtoupper si está disponible (UTF-8).
     * - Recorta a longitud máxima con mb_substr si existe.
     */
    function to_upper_clean(?string $s, int $maxLen): ?string {
        if ($s === null) return null;
        $s = trim($s);
        if ($s === '') return null;
        $s = preg_replace('/\s+/u', ' ', $s); // colapsa espacios
        $s = function_exists('mb_strtoupper') ? mb_strtoupper($s, 'UTF-8') : strtoupper($s);
        if (function_exists('mb_substr')) {
            $s = mb_substr($s, 0, $maxLen, 'UTF-8');
        } else {
            $s = substr($s, 0, $maxLen);
        }
        return $s;
    }

    try {
        // Seguridad básica
        if (!isset($_SESSION['id_usuario'])) {
            header('Location: ../../frontend/Login_LG.html?error=' . urlencode('Sesion expirada')); exit;
        }
        if (($_SESSION['rol'] ?? '') !== 'CAJA') {
            header('Location: ../../frontend/home.php?error=' . urlencode('sin_permiso')); exit;
        }

        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Método no permitido') . '&tab=icortesia'); exit;
        }

        $idUsuario = $_SESSION['id_usuario'];

        // === Entradas ===
        // CHECK: acepta "7891", "7.891", "7,891" -> 7891
        $checkRaw = $_POST['ic_check'] ?? null;
        $checkNum = null;
        if ($checkRaw !== null && $checkRaw !== '') {
            $digitsOnly = preg_replace('/\D+/', '', (string)$checkRaw);
            if ($digitsOnly !== '') $checkNum = (int)$digitsOnly;
        }

        // TEXTO -> MAYÚSCULAS
        $beneficiario = to_upper_clean($_POST['ic_persona'] ?? null, 100);
        $motivo       = to_upper_clean($_POST['ic_motivo']  ?? null, 500);

        // MONTO con coma o punto
        $monto = isset($_POST['ic_monto']) ? (float)str_replace(',', '.', $_POST['ic_monto']) : 0.0;
        if ($monto < 0) $monto = 0.0;

        // Responsable (viene de <select>)
        $idResp = isset($_POST['ic_responsable']) ? trim((string)$_POST['ic_responsable']) : '';

        // === Validaciones mínimas ===
        if ($checkNum === null) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Ingrese el CHECK numérico') . '&tab=icortesia'); exit;
        }
        if ($checkNum < 0 || $checkNum > 9999999999) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('CHECK fuera de rango (máx 10 dígitos)') . '&tab=icortesia'); exit;
        }
        if (!$beneficiario || !$motivo || $idResp === '') {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Faltan datos requeridos') . '&tab=icortesia'); exit;
        }

        // === Modelo ===
        $model = new InformeCortesia(
            null,           // ID (IDENTITY)
            null,           // FECHA (GETDATE() en BD)
            $checkNum,      // CHECK_CORTESIA (numérico)
            $beneficiario,  // NOMBRE_BENEFICIARIO (MAYÚSCULA)
            $motivo,        // MOTIVO_CORTESIA (MAYÚSCULA)
            $monto,         // MONTO_CORTESIA
            $idResp,        // ID_RESPONSABLE (FK)
            $idUsuario      // ID_USUARIO (FK)
        );

        // === Persistencia ===
        $dao = new InformeCortesiaDAO($conn);
        $ok  = $dao->insertar($model);

        header('Location: ../../frontend/app_Caja.php?' . ($ok ? 'ok=Cortesia+registrada' : 'err=No+se+pudo+registrar')
            . '&tab=icortesia');
        exit;

    } catch (Throwable $e) {
        error_log('Guardar_Informe_Cortesia: ' . $e->getMessage());
        header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Error interno') . '&tab=icortesia'); exit;
    }
?>