<?php
    // /backend/procesos/Guardar_Informe_Descuento.php
    session_start();
    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../clases/InformeDescuento.php';
    require_once __DIR__ . '/../dao/InformeDescuentoDAO.php';

    date_default_timezone_set('America/Lima');

    /**
     * Convierte a MAYÚSCULAS con limpieza de espacios.
     * - Colapsa espacios múltiples a uno.
     * - Usa mb_strtoupper si está disponible (UTF-8; mantiene acentos).
     * - Recorta a longitud máxima con mb_substr si existe.
     */
    function to_upper_clean(?string $s, int $maxLen): ?string {
        if ($s === null) return null;
        $s = trim($s);
        if ($s === '') return null;
        $s = preg_replace('/\s+/u', ' ', $s); // colapsa espacios
        $s = function_exists('mb_strtoupper') ? mb_strtoupper($s, 'UTF-8') : strtoupper($s);
        if (function_exists('mb_substr')) {
            $s = mb_substr($s, 0, $maxLen, 'UTF-8');
        } else {
            $s = substr($s, 0, $maxLen);
        }
        return $s;
    }

    try {
        if (!isset($_SESSION['id_usuario'])) {
            header('Location: ../../frontend/Login_LG.html?error=' . urlencode('Sesion expirada')); exit;
        }
        $idUsuario = $_SESSION['id_usuario'];

        // === Entradas ===
        // CHECK como número (DECIMAL(10,0)). Acepta "4569", "4.569", "4,569" -> 4569
        $checkRaw = $_POST['id_check'] ?? null;
        $checkNum = null;
        if ($checkRaw !== null && $checkRaw !== '') {
            $digitsOnly = preg_replace('/\D+/', '', (string)$checkRaw);
            if ($digitsOnly !== '') $checkNum = (int)$digitsOnly;
        }

        // Campos de TEXTO del usuario -> MAYÚSCULA
        $persona = to_upper_clean($_POST['id_persona'] ?? null, 100); // ✅ MAYÚSCULA
        $motivo  = to_upper_clean($_POST['id_motivo']  ?? null, 500); // ✅ MAYÚSCULA

        // Números con coma o punto
        $monto = isset($_POST['id_monto']) ? (float)str_replace(',', '.', $_POST['id_monto']) : 0.0;
        $porc  = isset($_POST['id_porc'])  ? (float)str_replace(',', '.', $_POST['id_porc'])  : 0.0;

        // Normalizaciones
        if ($monto < 0) $monto = 0.0;
        $porc = max(0.0, min(100.0, $porc));

        // Validaciones mínimas
        if ($checkNum === null) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Ingrese el CHECK numérico') . '&tab=idesc'); exit;
        }
        if ($checkNum < 0 || $checkNum > 9999999999) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('CHECK fuera de rango (máx 10 dígitos)') . '&tab=idesc'); exit;
        }
        if (!$persona || !$motivo || empty($_POST['id_responsable'])) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Faltan datos requeridos') . '&tab=idesc'); exit;
        }
        $idResp = trim($_POST['id_responsable']); // viene de un <select>, no es texto libre del usuario

        // Modelo (DAO calcula descuento S/ (1 dec) y total S/ (2 dec) con redondeo al paso)
        $model = new InformeDescuento(
            null,       // id
            null,       // fecha (GETDATE())
            $checkNum,  // CHECK_DESCUENTO (numérico)
            $persona,   // NOMBRE_PERSONA (MAYÚSCULA)
            $motivo,    // MOTIVO_DESCUENTO (MAYÚSCULA)
            $monto,
            $porc,
            null,       // DESCUENTO_PORCENTAJE (DAO)
            null,       // TOTAL_MONTO_DESCUENTO (DAO)
            $idResp,
            $idUsuario
        );

        $dao = new InformeDescuentoDAO($conn);
        $ok  = $dao->insertar($model);

        header('Location: ../../frontend/app_Caja.php?' . ($ok ? 'ok=Descuento+registrado' : 'err=No+se+pudo+registrar') . '&tab=idesc');
        exit;

    } catch (Throwable $e) {
        error_log('Guardar_Informe_Descuento: ' . $e->getMessage());
        header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Error interno') . '&tab=idesc'); exit;
    }
?>