<?php
    // Ubicación: /backend/procesos/Guardar_Prop_Fisico.php

    session_start(); // [1] NECESARIO para usar $_SESSION

    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';                     
    require_once __DIR__ . '/../clases/PropinaFisico.php';   
    require_once __DIR__ . '/../dao/PropinaFisicoDAO.php'; 

    if ($_SERVER["REQUEST_METHOD"] === "POST") {

        // [2] Validar sesión
        if (!isset($_SESSION['id_usuario'])) {
            // puedes redirigir al login
            header('Location: ../../frontend/Login_LB.html?error=' . urlencode('Sesion expirada'));
            exit;
        }

        // [3] Leer POST
        $idEmpleado      = $_POST['pf_mesero'] ?? '';
        $montoPropFisico = isset($_POST['pf_monto']) ? (float) $_POST['pf_monto'] : 0.0;
        $idUsuario       = $_SESSION['id_usuario'];

        if ($idEmpleado === '' || $montoPropFisico < 0) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('Datos inválidos'));
            exit;
        }

        // [4] Instanciar respetando tu constructor (id, fecha, idEmpleado, monto, idUsuario)
        $propina = new PropinaFisico(
            null,              // idPropFisico (lo genera SQL)
            null,              // fechaRegFisico (DEFAULT GETDATE())
            $idEmpleado,       // FK empleado
            $montoPropFisico,  // monto
            $idUsuario         // usuario de sesión
        );

        $dao = new PropinaFisicoDAO($conn);

        if ($dao->insertar($propina)) {
            header('Location: ../../frontend/app_Caja.php?ok=' . urlencode('Propina física registrada') . '&tab=pfisico');
            exit;
        } else {
            echo "Error al registrar: ";
            die(print_r(sqlsrv_errors(), true));
        }
    }
?>