<?php
    // /backend/procesos/Guardar_Prop_Tarjeta.php
    session_start();

    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../clases/PropinaTarjeta.php';
    require_once __DIR__ . '/../dao/PropinaTarjetaDAO.php';

    date_default_timezone_set('America/Lima');

    if ($_SERVER["REQUEST_METHOD"] === "POST") {

        if (!isset($_SESSION['id_usuario'])) {
            header('Location: ../../frontend/Login_LB.html?error=' . urlencode('Sesion expirada'));
            exit;
        }

        // Inputs
        $idPropReff = isset($_POST['pt_ref'])    ? trim((string)$_POST['pt_ref'])    : '';
        $idEmpleado = isset($_POST['pt_mesero']) ? trim((string)$_POST['pt_mesero']) : '';
        $monTarjeta = isset($_POST['pt_monto'])  ? (float)$_POST['pt_monto']         : null;

        $idUsuario  = $_SESSION['id_usuario'] ?? '';

        // Normaliza referencia
        $idPropReff = strtoupper(preg_replace('/\s+/', '', $idPropReff));

        // Validaciones
        $errores = [];
        if ($idPropReff === '' || strlen($idPropReff) > 10)  $errores[] = 'Referencia inválida (obligatoria y máx. 10).';
        if ($idEmpleado === '')                              $errores[] = 'Debe seleccionar un empleado.';
        if ($monTarjeta === null || !is_numeric($monTarjeta) || $monTarjeta < 0) {
            $errores[] = 'Monto de propina inválido.';
        }
        if (!empty($errores)) {
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode(implode(' ', $errores)) . '&tab=ptarjeta');
            exit;
        }

        // NETO = monto*0.95, "piso" a múltiplo de 0.10 (1 decimal) y se guarda con 2 decimales
        $netoBase     = $monTarjeta * 0.95;
        $netoFloor10  = floor($netoBase * 10) / 10;                 // 1 decimal exacto por piso
        $netoEntregar = (float) number_format($netoFloor10, 2, '.', ''); // 2 decimales p/ guardar

        // Construye entidad
        $prop = new PropinaTarjeta(
            null,          // ID auto (si tu tabla lo tiene)
            null,          // FECHA (DEFAULT GETDATE())
            $idPropReff,   // ID_PROP_REFF
            $idEmpleado,   // ID_EMPLEADO
            (float)$monTarjeta,   // MON_TARJETA (bruto)
            (float)$netoEntregar, // DESC_MON_TARJETA (usando como NETO entregado)
            $idUsuario
        );

        // Insert
        $dao = new PropinaTarjetaDAO($conn);
        $ok  = $dao->insertar($prop);

        if ($ok) {
            header('Location: ../../frontend/app_Caja.php?ok=' . urlencode('Propina tarjeta registrada') . '&tab=ptarjeta');
            exit;
        } else {
            // Log interno opcional: error_log(print_r(sqlsrv_errors(), true));
            header('Location: ../../frontend/app_Caja.php?err=' . urlencode('No se pudo registrar la propina tarjeta') . '&tab=ptarjeta');
            exit;
        }
    }
?>