<?php
    session_start();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        header('Location: ../../frontend/Login_LG.html'); exit;
    }

    require_once __DIR__ . '/../database/Conexion_SQL_Server.php';
    require_once __DIR__ . '/../dao/UsuarioDAO.php';

    $usuario    = trim($_POST['usuario']    ?? '');
    $contrasena = trim($_POST['contrasena'] ?? '');

    if ($usuario === '' || $contrasena === '') {
        header('Location: ../../frontend/Login_LG.html?error=campos'); exit;
    }

    try {
        $dao = new UsuarioDAO($conn);
        list($ok, $user, $msg) = $dao->validarCredenciales($usuario, $contrasena);

        if (!$ok) {
            header('Location: ../../frontend/Login_LG.html?error=' . urlencode($msg ?? 'credenciales')); exit;
        }

        session_regenerate_id(true); // seguridad básica
        $_SESSION['id_usuario'] = $user->getIdUsuario();
        $_SESSION['rol']        = $user->getRol();
        $_SESSION['login_time'] = date('Y-m-d H:i:s');

        // Redirección simple por rol
        switch ($_SESSION['rol']) {
            case 'RECEPCION': header('Location: ../../frontend/app_Recepcion.php'); break;
            case 'ADMIN': header('Location: ../../frontend/app_Admin.php'); break;
            case 'CAJA': header('Location: ../../frontend/app_Caja.php'); break;
            default:      header('Location: ../../frontend/home.php');  break;
        }
        exit;

    } catch (Exception $e) {
        // TEMPORAL: muestra el error real en pantalla
        echo "<pre>ERROR SERVER:\n" . htmlspecialchars($e->getMessage()) . "</pre>";
        exit;
    }

?>

