<?php
session_start();
header('Content-Type: application/json; charset=utf-8');

try {
    if (!isset($_SESSION['id_usuario'])) {
        echo json_encode(['ok'=>false,'error'=>'Sesión expirada']); exit;
    }
    if (($_SESSION['rol'] ?? '') !== 'ADMIN') {
        echo json_encode(['ok'=>false,'error'=>'Sin permiso']); exit;
    }

    // ===== Entradas =====
    $conteo = isset($_GET['conteo']) ? (float)$_GET['conteo'] : null;
    if ($conteo === null || $conteo < 0) {
        echo json_encode(['ok'=>false,'error'=>'Conteo físico inválido']); exit;
    }
    $idUsuario = $_SESSION['id_usuario'];

    // ===== Dependencias =====
    require_once __DIR__ . '/../database/conexion_sql_server.php'; // Tu archivo, no se toca
    require_once __DIR__ . '/../dao/InformeCierreCajaDAO.php';
    require_once __DIR__ . '/../../vendor/autoload.php'; // para PhpSpreadsheet

    // Ya tienes $conn desde tu archivo original
    if (!$conn) { throw new RuntimeException('Error: conexión SQL falló.'); }

    // ===== DAO =====
    $dao = new InformeCierreCajaDAO($conn);

    // ===== Armar objeto (SQL + Excel) =====
    $obj = $dao->buildCierreHoy($idUsuario, $conteo);

    $excel = $dao->leerMontosDesdeExcel();
    $sql_tot_pos  = $dao->sumReportePOSHoy(date('Y-m-d'));
    $sql_propinas = $dao->sumPropinaTarjetaHoy(date('Y-m-d'));

    $data = [
        'excel_medios' => [
            'total'          => $excel['total_revenue']  ?? 0,
            'efectivo'       => $excel['efectivo']       ?? 0,
            'funcionario'    => $excel['funcionario']    ?? 0,
            'pago_cortesia'  => $excel['pago_cortesia']  ?? 0,
            'yape'           => $excel['yape']           ?? 0,
            'transferencia'  => $excel['trasferencia']   ?? 0,
            'tarjeta'        => $excel['tarjeta']        ?? 0,
            'service_change' => $excel['service_change'] ?? 0,
        ],
        'sql_totales' => [
            'TOTAL_REPORT_POS'   => $sql_tot_pos,
            'TOTAL_PROP_TARJETA' => $sql_propinas['total_prop_tarjeta'],
            'TOTAL_PROP_TARJ_095'=> $sql_propinas['total_prop_tarj_095'],
        ],
        'calculados' => [
            'CONTEO_FISICO_CAJA'         => $obj->getConteoFisicoCaja(),
            'REPORT_TARJ_MENOS_PROP_TARJ'=> $obj->getReportTarjMenosPropTarj(),
            'EFECTIVO_1'                 => $obj->getEfectivo1(),
            'EFECTIVO_SISTEMA_FINAL'     => $obj->getEfectivoSistemaFinal(),
            'DINERO_SOBRANTE'            => $obj->getDineroSobrante(),
            'DINERO_FALTANTE'            => $obj->getDineroFaltante(),
            'OBSERVACION'                => $obj->getObservacionesCierreCaja(),
        ],
    ];

    echo json_encode(['ok'=>true,'data'=>$data], JSON_UNESCAPED_UNICODE);
} catch (Throwable $e) {
    echo json_encode(['ok'=>false,'error'=>$e->getMessage()]);
}
?>