<?php
    class CierreCaja {
        private $idCierre;
        private $fechaCierre;
        private $montoAperturaDia;
        private $totalEfectivoDia;
        private $totalYapePlinDia;
        private $totalTarjetaDia;
        private $totalReporteDia;
        private $totalRetirosDia;
        private $totalIngresosDia;
        private $efectivoSistemaFinal;
        private $conteoFisicoCaja;
        private $dineroSobrante;
        private $dineroFaltante;
        private $observacionCierre;
        private $idUsuario;

        public function __construct(
            ?int $idCierre = null,
            ?string $fechaCierre = null,
            float $montoAperturaDia = 0,
            float $totalEfectivoDia = 0,
            float $totalYapePlinDia = 0,
            float $totalTarjetaDia = 0,
            float $totalReporteDia = 0,
            float $totalRetirosDia = 0,
            float $totalIngresosDia = 0,
            float $efectivoSistemaFinal = 0,
            float $conteoFisicoCaja = 0,
            float $dineroSobrante = 0,
            float $dineroFaltante = 0,
            string $observacionCierre = '',
            string $idUsuario = ''
        ) {
            $this->idCierre = $idCierre;
            $this->fechaCierre = $fechaCierre;
            $this->montoAperturaDia = $montoAperturaDia;
            $this->totalEfectivoDia = $totalEfectivoDia;
            $this->totalYapePlinDia = $totalYapePlinDia;
            $this->totalTarjetaDia = $totalTarjetaDia;
            $this->totalReporteDia = $totalReporteDia;
            $this->totalRetirosDia = $totalRetirosDia;
            $this->totalIngresosDia = $totalIngresosDia;
            $this->efectivoSistemaFinal = $efectivoSistemaFinal;
            $this->conteoFisicoCaja = $conteoFisicoCaja;
            $this->dineroSobrante = $dineroSobrante;
            $this->dineroFaltante = $dineroFaltante;
            $this->observacionCierre = $observacionCierre;
            $this->idUsuario = $idUsuario;
        }

        // Getters
        public function getMontoAperturaDia(){ return $this->montoAperturaDia; }
        public function getTotalEfectivoDia(){ return $this->totalEfectivoDia; }
        public function getTotalYapePlinDia(){ return $this->totalYapePlinDia; }
        public function getTotalTarjetaDia(){ return $this->totalTarjetaDia; }
        public function getTotalReporteDia(){ return $this->totalReporteDia; }
        public function getTotalRetirosDia(){ return $this->totalRetirosDia; }
        public function getTotalIngresosDia(){ return $this->totalIngresosDia; }
        public function getEfectivoSistemaFinal(){ return $this->efectivoSistemaFinal; }
        public function getConteoFisicoCaja(){ return $this->conteoFisicoCaja; }
        public function getDineroSobrante(){ return $this->dineroSobrante; }
        public function getDineroFaltante(){ return $this->dineroFaltante; }
        public function getObservacionCierre(){ return $this->observacionCierre; }
        public function getIdUsuario(){ return $this->idUsuario; }
    }
?>
