<?php
    // backend/dao/AperturaCajaDAO.php
    require_once __DIR__ . '/../database/Conexion_DataBase.php'; // define $pdo
    require_once __DIR__ . '/../clases/AperturaCaja.php';

    class AperturaCajaDAO {
        /** @var PDO */
        private PDO $db;

        // Inyecta PDO. Si ya tienes $pdo global en Conexion_DataBase.php, puedes pasar ese.
        public function __construct(?PDO $conn = null) {
            // Si no te pasan la conexión, usa la global creada en Conexion_DataBase.php
            $this->db = $conn ?? $GLOBALS['pdo'];
        }

        // ==============================================
        // INSERTAR (solo UNA apertura global por día)
        // ==============================================
        public function insertar(AperturaCaja $apertura) {
            try {
                // 1) ¿Ya existe apertura hoy (global)?
                $checkSql = "SELECT 1
                            FROM APERTURA_CAJA
                            WHERE DATE(FECHA_APERTURA) = CURDATE()
                            LIMIT 1";
                $existe = (bool) $this->db->query($checkSql)->fetchColumn();
                if ($existe) {
                    return "YA_EXISTE";
                }

                // 2) Insertar si no existe
                $sql = "INSERT INTO APERTURA_CAJA (MONTO_APERTURA, ID_USUARIO)
                        VALUES (:monto, :usuario)";
                $stmt = $this->db->prepare($sql);
                $ok = $stmt->execute([
                    ':monto'   => $apertura->getMontoApertura(),
                    ':usuario' => $apertura->getIdUsuario()
                ]);
                return $ok ? true : false;

            } catch (PDOException $e) {
                // Si tienes un índice único por día, MySQL lanza 1062 (duplicate)
                if ((int)$e->errorInfo[1] === 1062) {
                    return "YA_EXISTE";
                }
                // Log opcional: error_log($e->getMessage());
                return false;
            }
        }

        // ==============================================
        // VERIFICAR si ya existe apertura HOY (global)
        // ==============================================
        public function existeAperturaHoy(): bool {
            try {
                $sql = "SELECT 1
                        FROM APERTURA_CAJA
                        WHERE DATE(FECHA_APERTURA) = CURDATE()
                        LIMIT 1";
                return (bool) $this->db->query($sql)->fetchColumn();
            } catch (PDOException $e) {
                // Puedes decidir si devolver false o relanzar
                return false;
            }
        }

        // ==============================================
        // LISTAR aperturas del día actual (debería ser 1)
        // ==============================================
        public function listarDeHoy(): array {
            try {
                $sql = "SELECT ID_APERTURA, FECHA_APERTURA, MONTO_APERTURA, ID_USUARIO
                        FROM APERTURA_CAJA
                        WHERE DATE(FECHA_APERTURA) = CURDATE()
                        ORDER BY ID_APERTURA DESC";
                $stmt = $this->db->query($sql);
                return $stmt->fetchAll(PDO::FETCH_ASSOC) ?: [];
            } catch (PDOException $e) {
                return [];
            }
        }
    }
?>