<?php
    // backend/dao/ProductoDAO.php
    require_once __DIR__ . '/../database/Conexion_DataBase.php'; // define $pdo
    require_once __DIR__ . '/../clases/Producto.php';

    class ProductoDAO {
        /** @var PDO */
        private PDO $db;

        public function __construct(?PDO $conn = null) {
            // Usa la conexión global creada en Conexion_DataBase.php si no te pasan otra
            $this->db = $conn ?? $GLOBALS['pdo'];
        }

        /**
         * CREAR (INSERT)
         * Asume columnas: ID_PRODUCTO (PK string), TIPO_PRODUCTO, PRECIO_PRODUCTO (DECIMAL), ESTADO_PRODUCTO
         */
        public function insertar(Producto $p): bool {
            $sql = "INSERT INTO PRODUCTO (ID_PRODUCTO, TIPO_PRODUCTO, PRECIO_PRODUCTO, ESTADO_PRODUCTO)
                    VALUES (:id, :tipo, :precio, :estado)";
            $stmt = $this->db->prepare($sql);
            return $stmt->execute([
                ':id'     => $p->getIdProducto(),
                ':tipo'   => $p->getTipoProducto(),
                ':precio' => $p->getPrecioProducto(),   // DECIMAL(10,2)
                ':estado' => $p->getEstadoProducto()
            ]);
        }

        // (Opcional) leer por id
        public function buscarPorId(string $id): ?array {
            $stmt = $this->db->prepare("SELECT * FROM PRODUCTO WHERE ID_PRODUCTO = :id LIMIT 1");
            $stmt->execute([':id' => $id]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            return $row ?: null;
        }

        // (Opcional) listar
        public function listar(): array {
            $sql = "SELECT ID_PRODUCTO, TIPO_PRODUCTO, PRECIO_PRODUCTO, ESTADO_PRODUCTO
                    FROM PRODUCTO
                    ORDER BY TIPO_PRODUCTO, ID_PRODUCTO";
            return $this->db->query($sql)->fetchAll(PDO::FETCH_ASSOC) ?: [];
        }
    }
?>