<?php
// backend/dao/UsuarioDAO.php
require_once __DIR__ . '/../database/Conexion_DataBase.php'; // define $pdo
require_once __DIR__ . '/../clases/Usuario.php';

class UsuarioDAO {
    /** @var PDO */
    private PDO $db;

    public function __construct(?PDO $conn = null) {
        $this->db = $conn ?? $GLOBALS['pdo'];
    }

    public function obtenerPorId(string $idUsuario): ?Usuario {
        try {
            $sql = "SELECT ID_USUARIO, CONTRASENA, ROL, ESTADO_USUARIO
                    FROM USUARIO
                    WHERE ID_USUARIO = :id
                    LIMIT 1";
            $stmt = $this->db->prepare($sql);
            $stmt->execute([':id' => $idUsuario]);
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if (!$row) return null;

            return new Usuario(
                $row['ID_USUARIO'],
                $row['CONTRASENA'],
                $row['ROL'],
                $row['ESTADO_USUARIO']
            );
        } catch (PDOException $e) {
            throw new Exception('Error en obtenerPorId: ' . $e->getMessage());
        }
    }

    /**
     * Valida credenciales en texto plano (igual a tu versión original).
     * Si ya usas hash en BD, cambia la comparación por password_verify($contrasenaPlano, $u->getContrasena()).
     */
    public function validarCredenciales(string $idUsuario, string $contrasenaPlano): array {
        $u = $this->obtenerPorId($idUsuario);
        if ($u === null) return [false, null, "Usuario no existe"];
        if (strtoupper($u->getEstadoUsuario()) !== 'ACTIVO') return [false, null, "Usuario inactivo"];

        // Plain text (como tu código original):
        if ($contrasenaPlano !== $u->getContrasena()) return [false, null, "Contraseña incorrecta"];

        // Si usas hash:
        // if (!password_verify($contrasenaPlano, $u->getContrasena())) return [false, null, "Contraseña incorrecta"];

        return [true, $u, null];
    }
}
