<?php
    // backend/procesos/generar_reporte.php
    session_start();

    require_once __DIR__ . '/../database/Conexion_DataBase.php';   // <-- usa $pdo (MySQL PDO)
    require_once __DIR__ . '/../dao/ReporteVentaDAO.php';          // <-- versión PDO/MySQL

    // Validar sesión
    if (!isset($_SESSION['id_usuario'])) {
    header('Location: ../../frontend/Login_Tulinda.html?error=' . urlencode('Sesion expirada'));
    exit;
    }

    try {
    // Instanciar DAO con la conexión PDO
    $dao = new ReporteVentaDAO($pdo);

    // 1) ¿Ya existe el reporte de HOY?
    $idExiste = $dao->existeReporteHoy();
    if ($idExiste > 0) {
        header('Location: ../../frontend/View_Vendedora.php?err=' . urlencode('Ya se generó el reporte de hoy') . '&id=' . $idExiste);
        exit;
    }

    // 2) No existe → generar (si envías apertura por POST, úsala; si no, el DAO la calcula)
    $montoApertura = $_POST['monto_apertura'] ?? null;
    if ($montoApertura === '') { $montoApertura = null; } // normaliza vacío

    $idReporte = $dao->generarDesdeVentasDeHoyGLOBAL($montoApertura, $_SESSION['id_usuario']);

    if ($idReporte !== false && is_int($idReporte)) {
        header('Location: ../../frontend/View_Vendedora.php?ok=' . urlencode('Reporte generado correctamente') . '&id=' . $idReporte);
    } else {
        header('Location: ../../frontend/View_Vendedora.php?err=' . urlencode('No se pudo generar el reporte'));
    }
    exit;

    } catch (Throwable $e) {
    // Manejo de error genérico
    // error_log($e->getMessage());
    header('Location: ../../frontend/View_Vendedora.php?err=' . urlencode('Error interno al generar el reporte'));
    exit;
    }
?>