<?php
    // Ubicación: /backend/procesos/Guardar_Apertura.php

    session_start();

    require_once __DIR__ . '/../database/Conexion_DataBase.php'; // <-- define $pdo (MySQL PDO)
    require_once __DIR__ . '/../clases/AperturaCaja.php';
    require_once __DIR__ . '/../dao/AperturaCajaDAO.php';

    if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // [1] Validar sesión
    if (!isset($_SESSION['id_usuario'])) {
        header('Location: ../../frontend/Login_Tulinda.html?error=' . urlencode('Sesion expirada'));
        exit;
    }

    // [2] Leer POST
    $montoAperturaStr = $_POST['monto_apertura'] ?? null;

    // Validaciones
    if ($montoAperturaStr === null || $montoAperturaStr === '' || !is_numeric($montoAperturaStr)) {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Monto inválido'));
        exit;
    }

    $montoApertura = (float)$montoAperturaStr;
    if ($montoApertura < 0) {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('El monto no puede ser negativo'));
        exit;
    }

    $idUsuario = $_SESSION['id_usuario'];

    // [4] DAO (PDO)
    $dao = new AperturaCajaDAO($pdo);

    // (Opcional) Si tu DAO tiene un método por usuario, puedes activarlo aquí.
    // if (method_exists($dao, 'existeAperturaHoyPorUsuario') && $dao->existeAperturaHoyPorUsuario($idUsuario)) {
    //   header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Ya existe una apertura registrada hoy'));
    //   exit;
    // }

    // [6] Entidad (ID y fecha los pone MySQL si tu tabla tiene AUTO_INCREMENT y DEFAULT CURRENT_TIMESTAMP)
    $apertura = new AperturaCaja(
        null,            // id_apertura (lo genera MySQL)
        null,            // fecha_apertura (DEFAULT CURRENT_TIMESTAMP en MySQL)
        $montoApertura,  // monto
        $idUsuario       // usuario sesión
    );

    // [7] Insertar (el DAO ya evita duplicado global del día)
    $ok = $dao->insertar($apertura);

    if ($ok === true) {
        header('Location: ../../frontend/app_RegistroVenta.php?ok=' . urlencode('Apertura registrada correctamente'));
        exit;
    } elseif ($ok === "YA_EXISTE") {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Ya existe una apertura registrada hoy'));
        exit;
    } else {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Error al registrar la apertura'));
        exit;
    }
    }
?>