<?php
    // Ubicación: /backend/procesos/Guardar_Cierre.php (o el nombre que usas)
    session_start();

    if (!isset($_SESSION['id_usuario'])) {
    $root = '/' . explode('/', trim($_SERVER['SCRIPT_NAME'], '/'))[0];
    header('Location: ' . $root . '/frontend/Login_Tulinda.html?error=' . urlencode('Sesion expirada'));
    exit;
    }

    require_once __DIR__ . '/../database/Conexion_DataBase.php'; // <-- define $pdo (PDO MySQL)
    require_once __DIR__ . '/../clases/CierreCaja.php';
    require_once __DIR__ . '/../dao/CierreCajaDAO.php';

    $idUsuario    = $_SESSION['id_usuario'];
    $PROJECT_ROOT = '/' . explode('/', trim($_SERVER['SCRIPT_NAME'], '/'))[0];
    $CERRAR_URL   = $PROJECT_ROOT . '/frontend/app_Cierre.php';

    // ---- 1) Bloquear si ya existe cierre global HOY (checado rápido por PDO)
    try {
    $yaExiste = (bool) $pdo->query("
        SELECT 1 FROM CIERRE_CAJA
        WHERE DATE(FECHA_CIERRE) = CURDATE()
        LIMIT 1
    ")->fetchColumn();

    if ($yaExiste) {
        header('Location: ' . $CERRAR_URL . '?err=' . urlencode('Ya existe un cierre global registrado hoy.'));
        exit;
    }
    } catch (Throwable $e) {
    header('Location: ' . $CERRAR_URL . '?err=' . urlencode('Error validando cierre existente'));
    exit;
    }

    // ---- 2) Leer POST (vacío => 0)
    $montoApertura = (isset($_POST['monto_apertura']) && $_POST['monto_apertura'] !== '') ? (float)$_POST['monto_apertura'] : 0.0;
    $totalEfectivo = (isset($_POST['total_efectivo']) && $_POST['total_efectivo'] !== '') ? (float)$_POST['total_efectivo'] : 0.0;
    $totalYapePlin = (isset($_POST['total_yape_plin']) && $_POST['total_yape_plin'] !== '') ? (float)$_POST['total_yape_plin'] : 0.0;
    $totalTarjeta  = (isset($_POST['total_tarjeta'])  && $_POST['total_tarjeta']  !== '') ? (float)$_POST['total_tarjeta']  : 0.0;
    $totalReporte  = (isset($_POST['total_reporte'])  && $_POST['total_reporte']  !== '') ? (float)$_POST['total_reporte']  : ($totalEfectivo + $totalYapePlin + $totalTarjeta);

    $totalRetiros  = (isset($_POST['total_retiros'])  && $_POST['total_retiros']  !== '') ? (float)$_POST['total_retiros']  : 0.0;
    $totalIngresos = (isset($_POST['total_ingresos']) && $_POST['total_ingresos'] !== '') ? (float)$_POST['total_ingresos'] : 0.0;
    $conteoFisico  = (isset($_POST['conteo_fisico'])  && $_POST['conteo_fisico']  !== '') ? (float)$_POST['conteo_fisico']  : 0.0;

    // ---- 3) Cálculos
    $efectivoSistema = ($montoApertura + $totalEfectivo) - $totalRetiros + $totalIngresos;

    $dineroSobrante = 0.0;
    $dineroFaltante = 0.0;
    if (abs($conteoFisico - $efectivoSistema) < 0.005) {
    $obs = 'EL CIERRE DE CAJA ES CORRECTO';
    } elseif ($conteoFisico > $efectivoSistema) {
    $dineroSobrante = $conteoFisico - $efectivoSistema;
    $obs = 'SOBRA DINERO: S/ ' . number_format($dineroSobrante, 2, '.', '');
    } else {
    $dineroFaltante = $efectivoSistema - $conteoFisico;
    $obs = 'FALTA DINERO: S/ ' . number_format($dineroFaltante, 2, '.', '');
    }

    // ---- 4) Insert vía DAO (PDO/MySQL)
    $cierre = new CierreCaja(
    null, null,
    $montoApertura, $totalEfectivo, $totalYapePlin, $totalTarjeta, $totalReporte,
    $totalRetiros, $totalIngresos, $efectivoSistema,
    $conteoFisico, $dineroSobrante, $dineroFaltante,
    $obs, $idUsuario
    );

    $dao = new CierreCajaDAO($pdo);
    $ok  = $dao->insertarCierre($cierre);

    // ---- 5) Redirección con mensaje
    if ($ok) {
    header('Location: ' . $CERRAR_URL . '?ok=' . urlencode('Cierre registrado correctamente.'));
    exit;
    } else {
    // Si el DAO internamente detectó duplicado (índice único) o falló:
    // Puedes volver a chequear si existe para mostrar msg coherente
    $yaExiste = (bool) $pdo->query("
        SELECT 1 FROM CIERRE_CAJA
        WHERE DATE(FECHA_CIERRE) = CURDATE()
        LIMIT 1
    ")->fetchColumn();
    $msg = $yaExiste ? 'Ya existe un cierre global registrado hoy.' : 'No se pudo registrar el cierre.';
    header('Location: ' . $CERRAR_URL . '?err=' . urlencode($msg));
    exit;
    }
?>