<?php
    // Ubicación: /backend/procesos/Guardar_Venta.php

    session_start();

    require_once __DIR__ . '/../database/Conexion_DataBase.php'; // <-- define $pdo (PDO MySQL)
    require_once __DIR__ . '/../clases/Venta.php';
    require_once __DIR__ . '/../dao/VentaDAO.php';

    if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // [1] Validar sesión
    if (!isset($_SESSION['id_usuario'])) {
        header('Location: ../../frontend/Login_Tulinda.html?error=' . urlencode('Sesion expirada'));
        exit;
    }

    // [2] Leer POST (sin monto; el DAO toma el precio desde PRODUCTO)
    $idProducto  = isset($_POST['id_producto']) ? trim($_POST['id_producto']) : null;
    $cantidad    = isset($_POST['cantidad']) ? (int)$_POST['cantidad'] : null;
    $descuento   = isset($_POST['descuento_producto']) ? (float)$_POST['descuento_producto'] : 0.0;
    $metodoPago  = isset($_POST['metodo_pago']) ? strtoupper(trim($_POST['metodo_pago'])) : null;
    $fechaManual = isset($_POST['fecha_registro_venta']) && $_POST['fecha_registro_venta'] !== ''
                    ? $_POST['fecha_registro_venta'] : null;

    $idUsuario   = $_SESSION['id_usuario'];

    // [3] Validaciones mínimas
    if (!$idProducto) {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Debe seleccionar un producto'));
        exit;
    }
    if ($cantidad === null || $cantidad <= 0) {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Cantidad inválida'));
        exit;
    }
    if ($descuento < 0) {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Descuento inválido'));
        exit;
    }
    $permitidos = ['EFECTIVO','YAPE_PLIN','TARJETA'];
    if (!in_array($metodoPago, $permitidos, true)) {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('Método de pago no permitido'));
        exit;
    }

    // (Opcional) Normalizar fecha manual a 'Y-m-d H:i:s' si te llega en otro formato
    // if ($fechaManual) { $fechaManual = date('Y-m-d H:i:s', strtotime($fechaManual)); }

    // [4] Entidad Venta (monto y total los calculará el DAO con el precio actual del PRODUCTO)
    $venta = new Venta(
        $fechaManual,   // FECHA_REGISTRO_VENTA (null -> DEFAULT CURRENT_TIMESTAMP en MySQL)
        null,           // ID_VENTA (AUTO_INCREMENT)
        $idProducto,    // ID_PRODUCTO
        $cantidad,      // CANTIDAD
        null,           // MONTO_PRODUCTO (lo obtiene el DAO)
        $descuento,     // DESCUENTO_PRODUCTO
        $metodoPago,    // METODO_PAGO
        null,           // TOTAL_VENTA (lo calcula el DAO)
        $idUsuario      // ID_USUARIO
    );

    // [5] DAO (PDO/MySQL)
    $dao = new VentaDAO($pdo);

    // [6] Insertar usando precio desde PRODUCTO
    $ok = $dao->insertarUsandoProducto($venta);

    if ($ok === true) {
        header('Location: ../../frontend/app_RegistroVenta.php?ok=' . urlencode('Venta registrada correctamente'));
        exit;
    } else {
        header('Location: ../../frontend/app_RegistroVenta.php?err=' . urlencode('No se pudo registrar la venta'));
        exit;
    }
    }
?>