<?php
    // Ubicación: /backend/procesos/Login.php
    session_start();

    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: ../../frontend/Login_Tulinda.html');
    exit;
    }

    require_once __DIR__ . '/../database/Conexion_DataBase.php'; // <-- usa PDO/MySQL
    require_once __DIR__ . '/../dao/UsuarioDAO.php';

    $usuario    = trim($_POST['usuario'] ?? '');
    $contrasena = trim($_POST['contrasena'] ?? '');

    if ($usuario === '' || $contrasena === '') {
    header('Location: ../../frontend/Login_Tulinda.html?error=campos');
    exit;
    }

    try {
    // [1] Conectarse a la BD
    $dao = new UsuarioDAO($pdo);

    // [2] Validar usuario
    list($ok, $user, $msg) = $dao->validarCredenciales($usuario, $contrasena);

    if (!$ok) {
        header('Location: ../../frontend/Login_Tulinda.html?error=' . urlencode($msg ?? 'credenciales'));
        exit;
    }

    // [3] Crear sesión segura
    session_regenerate_id(true);
    $_SESSION['id_usuario'] = $user->getIdUsuario();
    $_SESSION['rol']        = $user->getRol();
    $_SESSION['login_time'] = date('Y-m-d H:i:s');

    // [4] Redirigir según el rol
    switch ($_SESSION['rol']) {
        case 'VENDEDORA':
        header('Location: ../../frontend/app_RegistroVenta.php');
        break;
        case 'ADMIN':
        header('Location: ../../frontend/app_Inicio.php');
        break;
        default:
        header('Location: ../../frontend/home.php');
        break;
    }
    exit;

    } catch (Exception $e) {
    echo "<pre>ERROR SERVER:\n" . htmlspecialchars($e->getMessage()) . "</pre>";
    exit;
    }
?>