<?php
// Ubicación sugerida: /frontend/View_Admin.php
session_start();

if (!isset($_SESSION['id_usuario'])) {
  header('Location: Login_Tulinda.html?error=Sesion expirada'); exit;
}

// Solo ADMIN (ajusta si deseas permitir a vendedoras)
$rol = $_SESSION['rol'] ?? '';
if (!in_array($rol, ['ADMIN'], true)) {
  header('Location: home.php?error=sin_permiso'); exit;
}

$nombreVendedora = $_SESSION['nombre_vendedora'] ?? $_SESSION['id_usuario'];

require_once __DIR__ . '/../backend/database/Conexion_DataBase.php';

// --- Filtros de fecha (por defecto hoy) ---
date_default_timezone_set('America/Lima');
$hoy   = date('Y-m-d');
$desde = $_GET['desde'] ?? $hoy;
$hasta = $_GET['hasta'] ?? $hoy;

if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $desde)) { $desde = $hoy; }
if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $hasta)) { $hasta = $hoy; }

/* -----------------------------------------------------------
   APERTURA_CAJA
----------------------------------------------------------- */
$aperturas = [];
$apertura_total_suma = 0.0;
try {
  $sqlAperturas = "
    SELECT ID_APERTURA, FECHA_APERTURA, MONTO_APERTURA, ID_USUARIO
    FROM APERTURA_CAJA
    WHERE DATE(FECHA_APERTURA) BETWEEN :desde AND :hasta
    ORDER BY FECHA_APERTURA DESC, ID_APERTURA DESC
  ";
  $st = $pdo->prepare($sqlAperturas);
  $st->execute([':desde' => $desde, ':hasta' => $hasta]);
  $aperturas = $st->fetchAll(PDO::FETCH_ASSOC) ?: [];

  foreach ($aperturas as $r) {
    $apertura_total_suma += (float)$r['MONTO_APERTURA'];
  }
} catch (Throwable $e) {
  $aperturas = [];
  $apertura_total_suma = 0.0;
}

/* -----------------------------------------------------------
   VENTA
----------------------------------------------------------- */
$ventas = [];
$venta_total_suma = 0.0;
$venta_cant_reg   = 0;
$venta_metodos    = ['EFECTIVO'=>0.0, 'YAPE_PLIN'=>0.0, 'TARJETA'=>0.0];

try {
  $sqlVentas = "
    SELECT FECHA_REGISTRO_VENTA, ID_VENTA, ID_PRODUCTO, CANTIDAD,
           MONTO_PRODUCTO, DESCUENTO_PRODUCTO, TOTAL_VENTA, METODO_PAGO, ID_USUARIO
    FROM VENTA
    WHERE DATE(FECHA_REGISTRO_VENTA) BETWEEN :desde AND :hasta
    ORDER BY FECHA_REGISTRO_VENTA DESC, ID_VENTA DESC
  ";
  $stv = $pdo->prepare($sqlVentas);
  $stv->execute([':desde' => $desde, ':hasta' => $hasta]);
  $ventas = $stv->fetchAll(PDO::FETCH_ASSOC) ?: [];

  foreach ($ventas as $v) {
    $venta_total_suma += (float)$v['TOTAL_VENTA'];
    $venta_cant_reg++;
    $m = $v['METODO_PAGO'] ?? '';
    if (isset($venta_metodos[$m])) {
      $venta_metodos[$m] += (float)$v['TOTAL_VENTA'];
    }
  }
} catch (Throwable $e) {
  $ventas = [];
  $venta_total_suma = 0.0;
  $venta_cant_reg   = 0;
  $venta_metodos    = ['EFECTIVO'=>0.0, 'YAPE_PLIN'=>0.0, 'TARJETA'=>0.0];
}

/* -----------------------------------------------------------
   REPORTE_VENTA
----------------------------------------------------------- */
$reportes = [];
$rep_sum = [
  'MONTO_APERTURA'=>0.0, 'TOTAL_EFECTIVO'=>0.0, 'TOTAL_YAPE_PLIN'=>0.0,
  'TOTAL_TARJETA'=>0.0, 'TOTAL_DESCUENTO'=>0.0, 'TOTAL_REPORTE'=>0.0
];
$rep_cant = 0;

try {
  $sqlReportes = "
    SELECT FECHA_REPORT_VENTA, ID_REPORTE, MONTO_APERTURA,
           TOTAL_EFECTIVO, TOTAL_YAPE_PLIN, TOTAL_TARJETA,
           TOTAL_DESCUENTO, TOTAL_REPORTE, ID_USUARIO
    FROM REPORTE_VENTA
    WHERE DATE(FECHA_REPORT_VENTA) BETWEEN :desde AND :hasta
    ORDER BY FECHA_REPORT_VENTA DESC, ID_REPORTE DESC
  ";
  $str = $pdo->prepare($sqlReportes);
  $str->execute([':desde' => $desde, ':hasta' => $hasta]);
  $reportes = $str->fetchAll(PDO::FETCH_ASSOC) ?: [];

  foreach ($reportes as $r) {
    $rep_cant++;
    $rep_sum['MONTO_APERTURA']   += (float)$r['MONTO_APERTURA'];
    $rep_sum['TOTAL_EFECTIVO']   += (float)$r['TOTAL_EFECTIVO'];
    $rep_sum['TOTAL_YAPE_PLIN']  += (float)$r['TOTAL_YAPE_PLIN'];
    $rep_sum['TOTAL_TARJETA']    += (float)$r['TOTAL_TARJETA'];
    $rep_sum['TOTAL_DESCUENTO']  += (float)$r['TOTAL_DESCUENTO'];
    $rep_sum['TOTAL_REPORTE']    += (float)$r['TOTAL_REPORTE'];
  }
} catch (Throwable $e) {
  $reportes = [];
  $rep_sum = [
    'MONTO_APERTURA'=>0.0, 'TOTAL_EFECTIVO'=>0.0, 'TOTAL_YAPE_PLIN'=>0.0,
    'TOTAL_TARJETA'=>0.0, 'TOTAL_DESCUENTO'=>0.0, 'TOTAL_REPORTE'=>0.0
  ];
  $rep_cant = 0;
}

/* -----------------------------------------------------------
   CIERRE_CAJA
----------------------------------------------------------- */
$cierres = [];
$cie_cant  = 0;
$cie_sum   = [
  'TOTAL_RETIROS_DIA'=>0.0,'TOTAL_INGRESOS_DIA'=>0.0,
  'DINERO_SOBRANTE'=>0.0,'DINERO_FALTANTE'=>0.0
];

try {
  $sqlCierres = "
    SELECT FECHA_CIERRE, ID_CIERRE,
           MONTO_APERTURA_DIA, TOTAL_EFECTIVO_DIA, TOTAL_YAPE_PLIN_DIA,
           TOTAL_TARJETA_DIA, TOTAL_REPORTE_DIA,
           TOTAL_RETIROS_DIA, TOTAL_INGRESOS_DIA,
           EFECTIVO_SISTEMA_FINAL, CONTEO_FISICO_CAJA,
           DINERO_SOBRANTE, DINERO_FALTANTE,
           OBSERVACION_CIERRE, ID_USUARIO
    FROM CIERRE_CAJA
    WHERE DATE(FECHA_CIERRE) BETWEEN :desde AND :hasta
    ORDER BY FECHA_CIERRE DESC, ID_CIERRE DESC
  ";
  $stc = $pdo->prepare($sqlCierres);
  $stc->execute([':desde' => $desde, ':hasta' => $hasta]);
  $cierres = $stc->fetchAll(PDO::FETCH_ASSOC) ?: [];

  foreach ($cierres as $c) {
    $cie_cant++;
    $cie_sum['TOTAL_RETIROS_DIA'] += (float)$c['TOTAL_RETIROS_DIA'];
    $cie_sum['TOTAL_INGRESOS_DIA']+= (float)$c['TOTAL_INGRESOS_DIA'];
    $cie_sum['DINERO_SOBRANTE']   += (float)$c['DINERO_SOBRANTE'];
    $cie_sum['DINERO_FALTANTE']   += (float)$c['DINERO_FALTANTE'];
  }
} catch (Throwable $e) {
  $cierres = [];
  $cie_cant = 0;
  $cie_sum = [
    'TOTAL_RETIROS_DIA'=>0.0,'TOTAL_INGRESOS_DIA'=>0.0,
    'DINERO_SOBRANTE'=>0.0,'DINERO_FALTANTE'=>0.0
  ];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Tulinda • Historial</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Bootstrap + Iconos -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <!-- Tus estilos -->
  <link rel="stylesheet" href="../css/Estilos_RegistroVenta.css">
  <link rel="stylesheet" href="../css/Estilos_View_Admin.css">
</head>
<body>
  <!-- HEADER -->
  <header class="header-tulinda d-flex justify-content-between align-items-center p-3 shadow-sm">
    <div class="d-flex align-items-center gap-2">
      <div class="avatar"><i class="bi bi-person-fill"></i></div>
      <div>
        <strong><?= htmlspecialchars($nombreVendedora, ENT_QUOTES, 'UTF-8'); ?></strong><br>
        <small><?= htmlspecialchars($rol, ENT_QUOTES, 'UTF-8'); ?></small>
      </div>
    </div>
    <div class="d-flex gap-2">
      <a href="./app_Inicio.php" class="btn btn-rose-outline"><i class="bi bi-arrow-left"></i> Volver</a>
      <form action="../backend/procesos/seguridad/logout.php" method="post" class="m-0"
            onsubmit="return confirm('¿Deseas cerrar sesión?');">
        <button type="submit" class="btn btn-rose-outline">
          <i class="bi bi-box-arrow-right"></i> Cerrar sesión
        </button>
      </form>
    </div>
  </header>

  <div class="container container-tulinda mt-4">
    <!-- Filtros -->
    <section class="panel-card p-3 p-md-4 mb-4">
      <h2 class="h-title mb-2">Historial</h2>
      <div class="rule-rose"></div>
      <form class="row g-2" method="get" action="">
        <div class="col-sm-6 col-md-3">
          <label class="form-label">Desde</label>
          <input type="date" name="desde" value="<?= htmlspecialchars($desde) ?>" class="form-control" required>
        </div>
        <div class="col-sm-6 col-md-3">
          <label class="form-label">Hasta</label>
          <input type="date" name="hasta" value="<?= htmlspecialchars($hasta) ?>" class="form-control" required>
        </div>
        <div class="col-sm-12 col-md-3 d-flex align-items-end">
          <button class="btn btn-rose w-100" type="submit"><i class="bi bi-search"></i> Buscar</button>
        </div>
      </form>
    </section>

    <!-- Tabs -->
    <ul class="nav nav-tabs" id="historialTabs" role="tablist">
      <li class="nav-item" role="presentation">
        <button class="nav-link active" id="aperturas-tab" data-bs-toggle="tab" data-bs-target="#aperturas"
                type="button" role="tab">Aperturas</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="ventas-tab" data-bs-toggle="tab" data-bs-target="#ventas"
                type="button" role="tab">Ventas</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="reportes-tab" data-bs-toggle="tab" data-bs-target="#reportes"
                type="button" role="tab">Reportes</button>
      </li>
      <li class="nav-item" role="presentation">
        <button class="nav-link" id="cierres-tab" data-bs-toggle="tab" data-bs-target="#cierres"
                type="button" role="tab">Cierres</button>
      </li>
    </ul>

    <div class="tab-content panel-card p-3 p-md-4" id="historialTabsContent">
      <!-- TAB APERTURAS -->
      <div class="tab-pane fade show active" id="aperturas" role="tabpanel" tabindex="0">
        <div class="d-flex flex-wrap gap-2 mb-2">
          <span class="badge rounded-pill badge-tot">Total Aperturas: S/ <?= number_format($apertura_total_suma,2) ?></span>
          <span class="badge rounded-pill badge-tot">Registros: <?= count($aperturas) ?></span>
        </div>
        <?php if (empty($aperturas)): ?>
          <div class="alert alert-warning mt-2">No hay aperturas en el rango seleccionado.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda mt-2">
            <table class="table align-middle mb-0">
              <thead>
                <tr>
                  <th>Fecha/Hora</th>
                  <th>Monto</th>
                  <th>Usuario</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($aperturas as $a): ?>
                <tr>
                  <td><?= htmlspecialchars($a['FECHA_APERTURA']) ?></td>
                  <td>S/ <?= number_format((float)$a['MONTO_APERTURA'],2) ?></td>
                  <td><?= htmlspecialchars($a['ID_USUARIO']) ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>

      <!-- TAB VENTAS -->
      <div class="tab-pane fade" id="ventas" role="tabpanel" tabindex="0">
        <div class="d-flex flex-wrap gap-2 mb-2">
          <span class="badge rounded-pill badge-tot">Registros: <?= (int)$venta_cant_reg ?></span>
          <span class="badge rounded-pill badge-tot">Total ventas: S/ <?= number_format($venta_total_suma, 2) ?></span>
          <span class="badge rounded-pill badge-tot">Efectivo: S/ <?= number_format($venta_metodos['EFECTIVO'], 2) ?></span>
          <span class="badge rounded-pill badge-tot">Yape/Plin: S/ <?= number_format($venta_metodos['YAPE_PLIN'], 2) ?></span>
          <span class="badge rounded-pill badge-tot">Tarjeta: S/ <?= number_format($venta_metodos['TARJETA'], 2) ?></span>
        </div>
        <?php if (empty($ventas)): ?>
          <div class="alert alert-warning">No hay ventas en el rango seleccionado.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda">
            <table class="table align-middle mb-0">
              <thead>
                <tr>
                  <th>Fecha/Hora</th>
                  <th>ID Venta</th>
                  <th>Producto</th>
                  <th>Cant.</th>
                  <th>P.U.</th>
                  <th>Desc.</th>
                  <th>Total</th>
                  <th>Método</th>
                  <th>Usuario</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($ventas as $v): ?>
                <tr>
                  <td><?= htmlspecialchars($v['FECHA_REGISTRO_VENTA']) ?></td>
                  <td><?= (int)$v['ID_VENTA'] ?></td>
                  <td><?= htmlspecialchars($v['ID_PRODUCTO']) ?></td>
                  <td><?= (int)$v['CANTIDAD'] ?></td>
                  <td>S/ <?= number_format((float)$v['MONTO_PRODUCTO'],2) ?></td>
                  <td>S/ <?= number_format((float)$v['DESCUENTO_PRODUCTO'],2) ?></td>
                  <td><strong>S/ <?= number_format((float)$v['TOTAL_VENTA'],2) ?></strong></td>
                  <td><?= htmlspecialchars($v['METODO_PAGO']) ?></td>
                  <td><?= htmlspecialchars($v['ID_USUARIO']) ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>

      <!-- TAB REPORTES -->
      <div class="tab-pane fade" id="reportes" role="tabpanel" tabindex="0">
        <div class="d-flex flex-wrap gap-2 mb-2">
          <span class="badge rounded-pill badge-tot">Registros: <?= (int)$rep_cant ?></span>
          <span class="badge rounded-pill badge-tot">Apertura: S/ <?= number_format($rep_sum['MONTO_APERTURA'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Efectivo: S/ <?= number_format($rep_sum['TOTAL_EFECTIVO'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Yape/Plin: S/ <?= number_format($rep_sum['TOTAL_YAPE_PLIN'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Tarjeta: S/ <?= number_format($rep_sum['TOTAL_TARJETA'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Descuento: S/ <?= number_format($rep_sum['TOTAL_DESCUENTO'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Total Reporte: S/ <?= number_format($rep_sum['TOTAL_REPORTE'],2) ?></span>
        </div>
        <?php if (empty($reportes)): ?>
          <div class="alert alert-warning">No hay reportes en el rango seleccionado.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda">
            <table class="table align-middle mb-0">
              <thead>
                <tr>
                  <th>Fecha/Hora</th>
                  <th>ID Reporte</th>
                  <th>Apertura</th>
                  <th>Efectivo</th>
                  <th>Yape/Plin</th>
                  <th>Tarjeta</th>
                  <th>Descuento</th>
                  <th>Total Reporte</th>
                  <th>Usuario</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($reportes as $r): ?>
                <tr>
                  <td><?= htmlspecialchars($r['FECHA_REPORT_VENTA']) ?></td>
                  <td><?= (int)$r['ID_REPORTE'] ?></td>
                  <td>S/ <?= number_format((float)$r['MONTO_APERTURA'],2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_EFECTIVO'],2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_YAPE_PLIN'],2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_TARJETA'],2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_DESCUENTO'],2) ?></td>
                  <td><strong>S/ <?= number_format((float)$r['TOTAL_REPORTE'],2) ?></strong></td>
                  <td><?= htmlspecialchars($r['ID_USUARIO']) ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>

      <!-- TAB CIERRES -->
      <div class="tab-pane fade" id="cierres" role="tabpanel" tabindex="0">
        <div class="d-flex flex-wrap gap-2 mb-2">
          <span class="badge rounded-pill badge-tot">Registros: <?= (int)$cie_cant ?></span>
          <span class="badge rounded-pill badge-tot">Retiros: S/ <?= number_format($cie_sum['TOTAL_RETIROS_DIA'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Ingresos: S/ <?= number_format($cie_sum['TOTAL_INGRESOS_DIA'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Sobrante: S/ <?= number_format($cie_sum['DINERO_SOBRANTE'],2) ?></span>
          <span class="badge rounded-pill badge-tot">Faltante: S/ <?= number_format($cie_sum['DINERO_FALTANTE'],2) ?></span>
        </div>
        <?php if (empty($cierres)): ?>
          <div class="alert alert-warning">No hay cierres en el rango seleccionado.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda table-container-wide">
            <table class="table table-sm align-middle mb-0 table-cierres">
              <thead>
                <tr>
                  <th class="sticky-col">Fecha/Hora</th>
                  <th>ID Cierre</th>
                  <th class="text-money">Apertura</th>
                  <th class="text-money">Efec. Día</th>
                  <th class="text-money">Yape/Plin</th>
                  <th class="text-money">Tarjeta</th>
                  <th class="text-money">Total Reporte</th>
                  <th class="text-money">Retiros</th>
                  <th class="text-money">Ingresos</th>
                  <th class="text-money">Efec. Sistema</th>
                  <th class="text-money">Conteo</th>
                  <th class="text-money">Sobrante</th>
                  <th class="text-money">Faltante</th>
                  <th>Dif. / Estado</th>
                  <th>Obs.</th>
                  <th>Usuario</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($cierres as $c):
                $diff = ((float)$c['CONTEO_FISICO_CAJA']) - ((float)$c['EFECTIVO_SISTEMA_FINAL']);
                $chip = '<span class="chip-ok">Correcto</span>';
                if (abs($diff) >= 0.005) {
                  $chip = $diff > 0 ? '<span class="chip-warn">Sobra</span>' : '<span class="chip-bad">Falta</span>';
                }
              ?>
                <tr>
                  <td class="sticky-col"><?= htmlspecialchars($c['FECHA_CIERRE']) ?></td>
                  <td><?= (int)$c['ID_CIERRE'] ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['MONTO_APERTURA_DIA'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['TOTAL_EFECTIVO_DIA'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['TOTAL_YAPE_PLIN_DIA'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['TOTAL_TARJETA_DIA'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['TOTAL_REPORTE_DIA'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['TOTAL_RETIROS_DIA'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['TOTAL_INGRESOS_DIA'],2) ?></td>
                  <td class="text-money"><strong>S/ <?= number_format((float)$c['EFECTIVO_SISTEMA_FINAL'],2) ?></strong></td>
                  <td class="text-money"><strong>S/ <?= number_format((float)$c['CONTEO_FISICO_CAJA'],2) ?></strong></td>
                  <td class="text-money">S/ <?= number_format((float)$c['DINERO_SOBRANTE'],2) ?></td>
                  <td class="text-money">S/ <?= number_format((float)$c['DINERO_FALTANTE'],2) ?></td>
                  <td>
                    <div><strong><?= ($diff>=0 ? '+' : '-') . ' S/ ' . number_format(abs($diff),2) ?></strong></div>
                    <div><?= $chip ?></div>
                  </td>
                  <td><?= htmlspecialchars($c['OBSERVACION_CIERRE']) ?></td>
                  <td><?= htmlspecialchars($c['ID_USUARIO']) ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>

    <p class="text-center mb-4 footer-mini">Tulinda – Joyería Artesanal</p>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
