<?php
// /frontend/Historial_VendView_Vendedora.php (versión PDO/MySQL)
session_start();

if (!isset($_SESSION['id_usuario'])) {
  header('Location: Login_Tulinda.html?error=Sesion expirada'); exit;
}
$rol = $_SESSION['rol'] ?? '';
if (!in_array($rol, ['VENDEDORA', 'ADMIN'], true)) {
  header('Location: home.php?error=sin_permiso'); exit;
}
$nombreVendedora = $_SESSION['nombre_vendedora'] ?? $_SESSION['id_usuario'];

require_once __DIR__ . '/../backend/database/Conexion_DataBase.php'; // <-- $pdo (PDO MySQL)

// Perú + HOY
date_default_timezone_set('America/Lima');
$hoy = date('Y-m-d');

/* ========== APERTURAS de HOY (GLOBAL) ========== */
$aperturasHoy = [];
$aperturaTotal = 0.00;
try {
  $sqlAperturas = "
    SELECT ID_APERTURA, FECHA_APERTURA, MONTO_APERTURA, ID_USUARIO
    FROM APERTURA_CAJA
    WHERE DATE(FECHA_APERTURA) = :hoy
    ORDER BY FECHA_APERTURA DESC, ID_APERTURA DESC
  ";
  $stA = $pdo->prepare($sqlAperturas);
  $stA->execute([':hoy' => $hoy]);
  $aperturasHoy = $stA->fetchAll(PDO::FETCH_ASSOC) ?: [];
  foreach ($aperturasHoy as $a) { $aperturaTotal += (float)$a['MONTO_APERTURA']; }
} catch (Throwable $e) {
  $aperturasHoy = []; $aperturaTotal = 0.00;
}

/* ========== VENTAS de HOY (GLOBAL) ========== */
$ventas = [];
$venta_total_suma      = 0.00;
$venta_total_descuento = 0.00;
$venta_cant_reg        = 0;
$venta_metodos         = ['EFECTIVO'=>0.00, 'YAPE_PLIN'=>0.00, 'TARJETA'=>0.00];

try {
  $sqlVentas = "
    SELECT FECHA_REGISTRO_VENTA, ID_VENTA, ID_PRODUCTO, CANTIDAD,
           MONTO_PRODUCTO, DESCUENTO_PRODUCTO, TOTAL_VENTA, METODO_PAGO, ID_USUARIO
    FROM VENTA
    WHERE DATE(FECHA_REGISTRO_VENTA) = :hoy
    ORDER BY FECHA_REGISTRO_VENTA DESC, ID_VENTA DESC
  ";
  $stV = $pdo->prepare($sqlVentas);
  $stV->execute([':hoy' => $hoy]);
  $ventas = $stV->fetchAll(PDO::FETCH_ASSOC) ?: [];

  foreach ($ventas as $v) {
    $venta_total_suma      += (float)$v['TOTAL_VENTA'];
    $venta_total_descuento += (float)$v['DESCUENTO_PRODUCTO'];
    $venta_cant_reg++;
    $m = $v['METODO_PAGO'] ?? '';
    if (isset($venta_metodos[$m])) { $venta_metodos[$m] += (float)$v['TOTAL_VENTA']; }
  }
} catch (Throwable $e) {
  $ventas = [];
}

/* ========== REPORTE_VENTA de HOY (GLOBAL) ========== */
$reportesHoy = [];
try {
  $sqlRep = "
    SELECT FECHA_REPORT_VENTA, ID_REPORTE, MONTO_APERTURA,
           TOTAL_EFECTIVO, TOTAL_YAPE_PLIN, TOTAL_TARJETA,
           TOTAL_DESCUENTO, TOTAL_REPORTE, ID_USUARIO
    FROM REPORTE_VENTA
    WHERE DATE(FECHA_REPORT_VENTA) = :hoy
    ORDER BY FECHA_REPORT_VENTA DESC, ID_REPORTE DESC
  ";
  $stR = $pdo->prepare($sqlRep);
  $stR->execute([':hoy' => $hoy]);
  $reportesHoy = $stR->fetchAll(PDO::FETCH_ASSOC) ?: [];
} catch (Throwable $e) {
  $reportesHoy = [];
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Tulinda • Hoy (Global Vendedoras)</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="../css/Estilos_RegistroVenta.css">
  <link rel="stylesheet" href="../css/Estilos_View_Vendedora.css">
</head>
<body>
<header class="header-tulinda d-flex align-items-center justify-content-between px-3 py-2 shadow-sm flex-wrap gap-2">
  <div class="d-flex align-items-center gap-2">
    <div class="avatar"><i class="bi bi-person-fill"></i></div>
    <div class="lh-1">
      <strong><?= htmlspecialchars($nombreVendedora, ENT_QUOTES, 'UTF-8'); ?></strong><br>
      <small class="text-muted"><?= htmlspecialchars($rol, ENT_QUOTES, 'UTF-8'); ?></small>
    </div>
  </div>
  <div class="d-flex align-items-center gap-2 flex-wrap">
    <a href="./app_Cierre.php" class="btn btn-warning d-flex align-items-center gap-1">
      <i class="bi bi-calculator"></i> Cierre de Caja
    </a>
    <form id="formExportExcel" action="../backend/procesos/export/Exportar_Registro.php" method="post" class="m-0">
      <button type="submit" class="btn btn-success d-flex align-items-center gap-1">
        <i class="bi bi-file-earmark-excel-fill"></i> Exportar Excel
      </button>
    </form>
    <a href="./app_RegistroVenta.php" class="btn btn-rose-outline d-flex align-items-center gap-1">
      <i class="bi bi-cash-coin"></i> Volver a Registrar
    </a>
    <form action="../backend/procesos/seguridad/logout.php" method="post" class="m-0"
          onsubmit="return confirm('¿Deseas cerrar sesión?');">
      <button type="submit" class="btn btn-rose-outline d-flex align-items-center gap-1">
        <i class="bi bi-box-arrow-right"></i> Cerrar sesión
      </button>
    </form>
  </div>
</header>

<!-- Banner de estado (exportación) -->
<div id="exportBanner" class="export-banner" role="status" aria-live="polite"></div>

<div class="container container-tulinda mt-4">
  <!-- Alertas -->
  <?php if(isset($_GET['ok']) || isset($_GET['err']) || isset($_GET['msg']) || isset($_GET['error'])): ?>
    <div id="msgAlert" class="alert alert-dismissible fade show alert-fixed
         <?= (isset($_GET['ok']) || isset($_GET['msg'])) ? 'alert-success' : 'alert-danger' ?>">
      <?= isset($_GET['ok'])   ? htmlspecialchars($_GET['ok'])   :
         (isset($_GET['msg']) ? htmlspecialchars($_GET['msg']) :
         (isset($_GET['err']) ? htmlspecialchars($_GET['err']) : htmlspecialchars($_GET['error']))) ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  <?php endif; ?>

  <!-- Tabs -->
  <ul class="nav nav-tabs mb-0" id="historialTabs" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" id="aperturas-tab" data-bs-toggle="tab" data-bs-target="#aperturas"
              type="button" role="tab" aria-controls="aperturas" aria-selected="true">Aperturas</button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" id="ventas-tab" data-bs-toggle="tab" data-bs-target="#ventas" type="button"
              role="tab" aria-controls="ventas" aria-selected="false">Ventas</button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" id="reporte-tab" data-bs-toggle="tab" data-bs-target="#reporte" type="button"
              role="tab" aria-controls="reporte" aria-selected="false">Reporte Venta</button>
    </li>
  </ul>

  <div class="panel-card p-3 p-md-4 rounded-top-0">
    <h2 class="h-title mb-2">Resumen de hoy <span class="subtle">(<?= htmlspecialchars($hoy) ?>)</span></h2>
    <div class="rule-rose"></div>

    <!-- Badges -->
    <div class="d-flex flex-wrap gap-2 mb-3">
      <span class="badge rounded-pill badge-tot">💰 Apertura del día: S/ <?= number_format($aperturaTotal, 2) ?></span>
      <span class="badge rounded-pill badge-tot">🏷️ Descuentos: S/ <?= number_format($venta_total_descuento, 2) ?></span>
      <span class="badge rounded-pill badge-tot">💸 Total ventas: S/ <?= number_format($venta_total_suma, 2) ?></span>
      <span class="badge rounded-pill badge-tot">💵 Efectivo: S/ <?= number_format($venta_metodos['EFECTIVO'], 2) ?></span>
      <span class="badge rounded-pill badge-tot">📱 Yape/Plin: S/ <?= number_format($venta_metodos['YAPE_PLIN'], 2) ?></span>
      <span class="badge rounded-pill badge-tot">💳 Tarjeta: S/ <?= number_format($venta_metodos['TARJETA'], 2) ?></span>
    </div>

    <div class="tab-content" id="historialTabsContent">
      <!-- TAB APERTURAS -->
      <div class="tab-pane fade show active" id="aperturas" role="tabpanel" aria-labelledby="aperturas-tab" tabindex="0">
        <?php if (empty($aperturasHoy)): ?>
          <div class="alert alert-warning m-0">No hay aperturas registradas hoy.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda">
            <table class="table align-middle mb-0">
              <thead>
                <tr><th>Fecha/Hora</th><th>Monto</th></tr>
              </thead>
              <tbody>
              <?php foreach ($aperturasHoy as $a): ?>
                <tr>
                  <td><?= htmlspecialchars($a['FECHA_APERTURA']) ?></td>
                  <td><strong>S/ <?= number_format((float)$a['MONTO_APERTURA'], 2) ?></strong></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>

      <!-- TAB VENTAS -->
      <div class="tab-pane fade" id="ventas" role="tabpanel" aria-labelledby="ventas-tab" tabindex="0">
        <?php if (empty($ventas)): ?>
          <div class="alert alert-warning m-0">No hay ventas registradas hoy.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda">
            <table class="table align-middle mb-0">
              <thead>
                <tr>
                  <th>Fecha/Hora</th><th>ID Venta</th><th>Producto</th><th>Cant.</th>
                  <th>P.U.</th><th>Desc.</th><th>Total</th><th>Método</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($ventas as $v): ?>
                <tr>
                  <td><?= htmlspecialchars($v['FECHA_REGISTRO_VENTA']) ?></td>
                  <td><?= (int)$v['ID_VENTA'] ?></td>
                  <td><?= htmlspecialchars($v['ID_PRODUCTO']) ?></td>
                  <td><?= (int)$v['CANTIDAD'] ?></td>
                  <td>S/ <?= number_format((float)$v['MONTO_PRODUCTO'], 2) ?></td>
                  <td>S/ <?= number_format((float)$v['DESCUENTO_PRODUCTO'], 2) ?></td>
                  <td><strong>S/ <?= number_format((float)$v['TOTAL_VENTA'], 2) ?></strong></td>
                  <td><?= htmlspecialchars($v['METODO_PAGO']) ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>

      <!-- TAB REPORTE_VENTA (GLOBAL HOY) -->
      <div class="tab-pane fade" id="reporte" role="tabpanel" aria-labelledby="reporte-tab" tabindex="0">
        <?php if (empty($reportesHoy)): ?>
          <div class="alert alert-info m-0">Aún no se ha generado el reporte del día.</div>
        <?php else: ?>
          <div class="table-responsive table-tulinda">
            <table class="table align-middle mb-0">
              <thead>
                <tr>
                  <th>Fecha/Hora</th><th>ID Reporte</th><th>Apertura</th><th>Efectivo</th>
                  <th>Yape/Plin</th><th>Tarjeta</th><th>Descuento</th><th>Total Reporte</th>
                </tr>
              </thead>
              <tbody>
              <?php foreach ($reportesHoy as $r): ?>
                <tr>
                  <td><?= htmlspecialchars($r['FECHA_REPORT_VENTA']) ?></td>
                  <td><?= (int)$r['ID_REPORTE'] ?></td>
                  <td>S/ <?= number_format((float)$r['MONTO_APERTURA'], 2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_EFECTIVO'], 2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_YAPE_PLIN'], 2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_TARJETA'], 2) ?></td>
                  <td>S/ <?= number_format((float)$r['TOTAL_DESCUENTO'], 2) ?></td>
                  <td><strong>S/ <?= number_format((float)$r['TOTAL_REPORTE'], 2) ?></strong></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <p class="text-center mb-4 footer-mini">Tulinda – Joyería Artesanal</p>
</div>

<!-- JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" defer></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('formExportExcel');
  const banner = document.getElementById('exportBanner');

  const showBanner = (type, title, detail = '') => {
    banner.className = 'export-banner show ' + (type === 'ok' ? 'success' : 'error');
    const icon = type === 'ok' ? 'bi-check-lg' : 'bi-exclamation-lg';
    const lead = type === 'ok' ? 'Exportación completada' : 'No se pudo exportar';
    banner.innerHTML = `
      <div class="icon"><i class="bi ${icon}"></i></div>
      <div class="msg">${title || lead}</div>
      ${detail ? `<div class="sub">${detail}</div>` : ''}
      <button class="close-btn" aria-label="Cerrar" title="Cerrar">&times;</button>
    `;
    banner.querySelector('.close-btn').onclick = () => banner.classList.remove('show');
  };

  form.addEventListener('submit', async (e) => {
    e.preventDefault();
    showBanner('ok', 'Exportando…', 'Por favor, espera unos segundos');
    try {
      const resp = await fetch(form.action, { method: 'POST' });
      const text = await resp.text();
      if (resp.ok && /Archivo exportado correctamente/i.test(text)) {
        showBanner('ok', '✅ Archivo exportado correctamente');
      } else {
        showBanner('err', '❌ Error en la exportación, archivo excel abierto');
      }
    } catch (err) {
      showBanner('err', '❌ Error de red', err.message);
    }
  });
});
</script>
</body>
</html>
