<?php
session_start();

if (!isset($_SESSION['id_usuario'])) {
  header('Location: Login_Tulinda.html?error=Sesion expirada'); exit;
}
if (!in_array($_SESSION['rol'] ?? '', ['VENDEDORA', 'ADMIN'], true)) {
  header('Location: home.php?error=sin_permiso'); exit;
}

$idUsuario       = $_SESSION['id_usuario'];
$rol             = $_SESSION['rol'] ?? '';
$estado          = $_SESSION['estado'] ?? '';
$nombreVendedora = $_SESSION['nombre_vendedora'] ?? $idUsuario;

require_once __DIR__ . '/../backend/database/Conexion_DataBase.php'; // <-- PDO MySQL
date_default_timezone_set('America/Lima');

/* ===== JALAR DATOS AUTOMÁTICOS (MySQL) =====
   Antes: ISNULL + CONVERT(date, col) = CONVERT(date, GETDATE())
   Ahora: IFNULL + DATE(col) = CURDATE()
*/
try {
  // Apertura del día
  $sqlApertura = "SELECT IFNULL(SUM(MONTO_APERTURA), 0) AS APERTURA
                  FROM APERTURA_CAJA
                  WHERE DATE(FECHA_APERTURA) = CURDATE()";
  $apertura = (float)($pdo->query($sqlApertura)->fetchColumn() ?? 0);

  // Ventas del día por método
  $sqlVentas = "SELECT
                  IFNULL(SUM(CASE WHEN METODO_PAGO='EFECTIVO'  THEN TOTAL_VENTA ELSE 0 END),0) AS EFECTIVO,
                  IFNULL(SUM(CASE WHEN METODO_PAGO='YAPE_PLIN' THEN TOTAL_VENTA ELSE 0 END),0) AS YAPE_PLIN,
                  IFNULL(SUM(CASE WHEN METODO_PAGO='TARJETA'   THEN TOTAL_VENTA ELSE 0 END),0) AS TARJETA
                FROM VENTA
                WHERE DATE(FECHA_REGISTRO_VENTA) = CURDATE()";
  $rowV = $pdo->query($sqlVentas)->fetch(PDO::FETCH_ASSOC) ?: ['EFECTIVO'=>0,'YAPE_PLIN'=>0,'TARJETA'=>0];

  $efectivo  = (float)$rowV['EFECTIVO'];
  $yape_plin = (float)$rowV['YAPE_PLIN'];
  $tarjeta   = (float)$rowV['TARJETA'];

  $total_reporte = $efectivo + $yape_plin + $tarjeta;

} catch (Throwable $e) {
  // Fallback seguro si hubiera algún error de consulta
  $apertura = 0.0; $efectivo = 0.0; $yape_plin = 0.0; $tarjeta = 0.0; $total_reporte = 0.0;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Cierre de Caja – Tulinda</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <!-- Bootstrap + Iconos -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="stylesheet" href="../css/Estilos_AppCierre.css">
</head>
<body>
  <!-- Header -->
  <header class="header-tulinda px-3 py-2 shadow-sm">
    <div class="row align-items-center g-2 w-100">
      <div class="col-12 col-md-4 d-flex align-items-center gap-2">
        <div class="avatar"><i class="bi bi-person-fill"></i></div>
        <div class="lh-1 text-truncate">
          <strong class="text-truncate d-block"><?= htmlspecialchars($nombreVendedora, ENT_QUOTES, 'UTF-8'); ?></strong>
          <small class="text-muted text-truncate d-block"><?= htmlspecialchars($rol, ENT_QUOTES, 'UTF-8'); ?></small>
        </div>
      </div>
      <div class="col-12 col-md-4 d-flex justify-content-center">
        <a href="./View_Vendedora.php" class="chip-link text-center">
          <i class="bi bi-bar-chart-line"></i> Ver Registros de Venta
        </a>
      </div>
      <div class="col-12 col-md-4">
        <div class="header-actions d-flex flex-wrap justify-content-start justify-content-md-end gap-2">
          <a href="./app_RegistroVenta.php" class="btn btn-outline-dark">
            <i class="bi bi-cash-coin"></i> Volver a Registrar
          </a>
          <form action="../backend/procesos/seguridad/logout.php" method="post" class="m-0"
                onsubmit="return confirm('¿Deseas cerrar sesión?');">
            <button type="submit" class="btn btn-rose-outline">
              <i class="bi bi-box-arrow-right"></i> Cerrar sesión
            </button>
          </form>
        </div>
      </div>
    </div>
  </header>

  <?php if (isset($_GET['ok']) || isset($_GET['err'])): ?>
    <div class="alert <?= isset($_GET['ok']) ? 'alert-success' : 'alert-danger' ?> alert-dismissible fade show" role="alert">
      <i class="bi <?= isset($_GET['ok']) ? 'bi-check-circle-fill' : 'bi-exclamation-triangle-fill' ?>"></i>
      <?= htmlspecialchars($_GET['ok'] ?? $_GET['err'], ENT_QUOTES, 'UTF-8') ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
  <?php endif; ?>

  <div class="container py-4">
    <div class="d-flex align-items-center justify-content-between flex-wrap gap-2 mb-3">
      <h2 class="page-title m-0">Cierre de Caja – Tulinda</h2>
    </div>

    <div class="row g-4">
      <!-- Izquierda: Formulario -->
      <div class="col-lg-8">
        <section class="panel-card p-3 p-md-4">
          <form action="../backend/procesos/Guardar_Cierre.php" method="post" class="row g-3" id="formCierre">
            <!-- Muestran info jalada (readonly) -->
            <div class="col-md-3">
              <label class="form-label">Apertura (S/)</label>
              <input type="number" class="form-control readonly" value="<?= number_format($apertura,2,'.','') ?>" readonly>
              <input type="hidden" name="monto_apertura" id="monto_apertura" value="<?= number_format($apertura,2,'.','') ?>">
            </div>
            <div class="col-md-3">
              <label class="form-label">Efectivo (S/)</label>
              <input type="number" class="form-control readonly" value="<?= number_format($efectivo,2,'.','') ?>" readonly>
              <input type="hidden" name="total_efectivo" id="total_efectivo" value="<?= number_format($efectivo,2,'.','') ?>">
            </div>
            <div class="col-md-3">
              <label class="form-label">Yape/Plin (S/)</label>
              <input type="number" class="form-control readonly" value="<?= number_format($yape_plin,2,'.','') ?>" readonly>
              <input type="hidden" name="total_yape_plin" id="total_yape_plin" value="<?= number_format($yape_plin,2,'.','') ?>">
            </div>
            <div class="col-md-3">
              <label class="form-label">Tarjeta (S/)</label>
              <input type="number" class="form-control readonly" value="<?= number_format($tarjeta,2,'.','') ?>" readonly>
              <input type="hidden" name="total_tarjeta" id="total_tarjeta" value="<?= number_format($tarjeta,2,'.','') ?>">
            </div>
            <div class="col-md-3">
              <label class="form-label">Total Reporte (S/)</label>
              <input type="number" class="form-control readonly" value="<?= number_format($total_reporte,2,'.','') ?>" readonly>
              <input type="hidden" name="total_reporte" id="total_reporte" value="<?= number_format($total_reporte,2,'.','') ?>">
            </div>

            <hr class="mt-2">

            <!-- SOLO estos 3 se llenan -->
            <div class="col-md-4">
              <label class="form-label">Total Retiros (S/)</label>
              <input type="number" step="0.01" name="total_retiros" id="total_retiros" class="form-control" placeholder="0.00">
            </div>
            <div class="col-md-4">
              <label class="form-label">Total Ingresos (S/)</label>
              <input type="number" step="0.01" name="total_ingresos" id="total_ingresos" class="form-control" placeholder="0.00">
            </div>
            <div class="col-md-4">
              <label class="form-label">Conteo Físico (S/)</label>
              <input type="number" step="0.01" name="conteo_fisico" id="conteo_fisico" class="form-control" required>
            </div>

            <div class="col-12 d-flex justify-content-end">
              <button class="btn btn-warning"><i class="bi bi-calculator"></i> Registrar Cierre</button>
            </div>
          </form>
        </section>
      </div>

      <!-- Derecha: Resumen -->
      <div class="col-lg-4">
        <section class="panel-card p-3 p-md-4 sticky-md summary-card">
          <div class="d-flex align-items-center justify-content-between mb-2">
            <h5 class="m-0 fw-bold">Resumen</h5>
            <span id="chipEstado" class="chip chip-pend"><i class="bi bi-hourglass-split"></i> Pendiente</span>
          </div>

          <div class="row"><div class="col-7">Apertura</div><div class="col-5 text-end valor" id="vApertura">S/ <?= number_format($apertura,2,'.','') ?></div></div>
          <div class="row"><div class="col-7">Ventas Efectivo</div><div class="col-5 text-end valor" id="vEfectivo">S/ <?= number_format($efectivo,2,'.','') ?></div></div>
          <div class="row"><div class="col-7">Retiros (–)</div><div class="col-5 text-end" id="vRetiros">S/ 0.00</div></div>
          <div class="row"><div class="col-7">Ingresos (+)</div><div class="col-5 text-end" id="vIngresos">S/ 0.00</div></div>
          <div class="row"><div class="col-7 fw-semibold">Efectivo Sistema</div><div class="col-5 text-end valor" id="vSistema">S/ <?= number_format($apertura + $efectivo,2,'.','') ?></div></div>
          <div class="row"><div class="col-7">Conteo Físico</div><div class="col-5 text-end" id="vConteo">S/ 0.00</div></div>
          <div class="row"><div class="col-7 fw-semibold">Diferencia</div><div class="col-5 text-end valor" id="vDiferencia">S/ 0.00</div></div>

          <hr>
          <div class="small text-muted">
            <i class="bi bi-info-circle"></i>
            Efectivo del sistema = (Apertura + Efectivo) – Retiros + Ingresos.
          </div>
        </section>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    // Helpers
    const $ = (id) => document.getElementById(id);
    const num = (val) => { const n = parseFloat(val); return Number.isFinite(n) ? n : 0; };
    const money = (n) => 'S/ ' + (num(n)).toFixed(2);

    // Base (jalados)
    const monto_apertura = num($('monto_apertura')?.value);
    const total_efectivo = num($('total_efectivo')?.value);

    // Inputs editables
    const inpRetiros = $('total_retiros');
    const inpIngresos = $('total_ingresos');
    const inpConteo = $('conteo_fisico');

    // Vistas del resumen
    const vRetiros = $('vRetiros');
    const vIngresos = $('vIngresos');
    const vSistema = $('vSistema');
    const vConteo = $('vConteo');
    const vDiferencia = $('vDiferencia');
    const chipEstado = $('chipEstado');

    function recalcular() {
      const retiros  = num(inpRetiros?.value);
      const ingresos = num(inpIngresos?.value);
      const conteo   = num(inpConteo?.value);

      const sistema = (monto_apertura + total_efectivo) - retiros + ingresos;
      const diff    = conteo - sistema;

      if (vRetiros)    vRetiros.textContent    = money(retiros);
      if (vIngresos)   vIngresos.textContent   = money(ingresos);
      if (vSistema)    vSistema.textContent    = money(sistema);
      if (vConteo)     vConteo.textContent     = money(conteo);
      if (vDiferencia) vDiferencia.textContent = money(diff);

      if (chipEstado) {
        chipEstado.classList.remove('chip-pend', 'chip-ok', 'chip-bad');
        if (!inpConteo.value) {
          chipEstado.classList.add('chip-pend');
          chipEstado.innerHTML = '<i class="bi bi-hourglass-split"></i> Pendiente';
        } else if (Math.abs(diff) < 0.005) {
          chipEstado.classList.add('chip-ok');
          chipEstado.innerHTML = '<i class="bi bi-check2-circle"></i> Correcto';
        } else if (diff > 0) {
          chipEstado.classList.add('chip-pend');
          chipEstado.innerHTML = '<i class="bi bi-coin"></i> Sobra ' + money(diff);
        } else {
          chipEstado.classList.add('chip-bad');
          chipEstado.innerHTML = '<i class="bi bi-exclamation-octagon"></i> Falta ' + money(-diff);
        }
      }
    }

    ['input','change'].forEach(evt => {
      inpRetiros?.addEventListener(evt, recalcular);
      inpIngresos?.addEventListener(evt, recalcular);
      inpConteo?.addEventListener(evt, recalcular);
    });
    recalcular();
  </script>
</body>
</html>
