<?php
    session_start();

    // [1] Verifica si hay sesión iniciada
    if (!isset($_SESSION['id_usuario'])) {
        header('Location: Login_Tulinda.html?error=Sesion expirada'); 
        exit;
    }

    // [2] Permitir solo VENDEDORA o ADMIN
    if (!in_array($_SESSION['rol'] ?? '', ['ADMIN'], true)) {
        header('Location: home.php?error=sin_permiso'); 
        exit;
    }

    // [3] Variables de sesión
    $idUsuario       = $_SESSION['id_usuario'];
    $rol             = $_SESSION['rol'] ?? '';
    $estado          = $_SESSION['estado'] ?? '';
    $nombreVendedora = $_SESSION['nombre_vendedora'] ?? $idUsuario;

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Seleccionar Interfaz – Tulinda</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* ====== Estilos personalizados ====== */
        body {
            min-height: 100vh;
            background: linear-gradient(135deg, #f8e1e7, #ffe9f3);
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: "Inter", system-ui, sans-serif;
            color: #3b2a2a;
        }

        .panel {
            background-color: white;
            border-radius: 20px;
            box-shadow: 0 6px 18px rgba(0, 0, 0, 0.15);
            text-align: center;
            padding: 40px 60px;
            transition: all 0.3s ease-in-out;
            width: 380px;
        }

        .panel:hover {
            transform: scale(1.02);
        }

        h2 {
            font-weight: 700;
            color: #b44c6b;
            margin-bottom: 20px;
        }

        .btn-custom {
            background-color: #b44c6b;
            color: white;
            font-weight: 600;
            border-radius: 10px;
            width: 100%;
            padding: 12px;
            margin-top: 10px;
            transition: all 0.3s ease;
        }

        .btn-custom:hover {
            background-color: #963a56;
        }

        .footer-text {
            margin-top: 25px;
            font-size: 0.9rem;
            color: #7b6666;
        }
    </style>
</head>

<body>
    <div class="panel">
        <h2>Selecciona tu Interfaz</h2>
        <p class="mb-4">Elige según tu rol de acceso</p>

        <button class="btn btn-custom" onclick="window.location.href='app_RegistroVenta.php'">
            💎 Interfaz Vendedoras
        </button>

        <button class="btn btn-custom" onclick="window.location.href='View_Admin.php'">
            ⚙️ Interfaz Administrador
        </button>

        <div class="footer-text">© 2025 Tulinda Joyería Artesanal</div>
    </div>
</body>

</html>