<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AperturaCaja;

class AperturaCajaController extends Controller
{
    private function ensureAllowed(array $roles)
    {
        if (!in_array(session('usuario.ROL'), $roles)) abort(403);
    }

    public function index()
    {
        $this->ensureAllowed(['ADMIN', 'VENDEDOR']);

        // ✅ SOLO HOY (ya no historial)
        $aperturas = AperturaCaja::query()
            ->whereDate('FECHA_APERTURA', now())
            ->orderByDesc('FECHA_APERTURA')
            ->paginate(10);

        return view('apertura.index', compact('aperturas'));
    }

    public function create()
    {
        $this->ensureAllowed(['ADMIN', 'VENDEDOR']);

        // ✅ Para que TODOS vean si ya hay apertura hoy
        $aperturaHoy = AperturaCaja::whereDate('FECHA_APERTURA', now())->first();

        return view('apertura.create', compact('aperturaHoy'));
    }

    public function store(Request $request)
    {
        $this->ensureAllowed(['ADMIN', 'VENDEDOR']);

        $request->validate([
            'MONTO_APERTURA' => 'required|numeric|min:0'
        ]);

        // ✅ Bloquea apertura duplicada para TODOS
        if (AperturaCaja::whereDate('FECHA_APERTURA', now())->exists()) {
            return back()->with('error', 'Ya existe una apertura registrada hoy.');
        }

        // ✅ Seguridad: si no hay empleado en sesión, no guardes
        $idEmpleado = session('usuario.ID_EMPLEADO');
        if (!$idEmpleado) {
            return back()->with('error', 'No se encontró el ID del empleado en sesión. Cierra sesión e ingresa de nuevo.');
        }

        AperturaCaja::create([
            'FECHA_APERTURA'  => now(),
            'MONTO_APERTURA'  => $request->MONTO_APERTURA,
            'ID_EMPLEADO'     => $idEmpleado,
        ]);

        return redirect()->route('apertura.index')->with('ok', 'Apertura registrada.');
    }
}
