<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Empleado;

class EmpleadoController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $empleados = Empleado::orderBy('created_at', 'desc')->paginate(10);
        return view('empleados.index', compact('empleados'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('empleados.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $data = $request->validate([
            'ID_EMPLEADO' => 'required|string|max:20|unique:empleados,ID_EMPLEADO',
            'NOMBRE_EMPLEADO' => 'required|string|max:80',
            'APELLIDO_EMPLEADO' => 'required|string|max:80',
            'DNI_EMPLEADO' => 'required|string|size:8|unique:empleados,DNI_EMPLEADO',
            'EDAD_EMPLEADO' => 'nullable|integer|min:16|max:99',
            'TELEFONO_EMPLEADO' => 'nullable|string|size:9',
            'ESTADO_EMPLEADO' => 'required|in:ACTIVO,INACTIVO',
        ]);

        Empleado::create($data);
        return redirect()->route('empleados.index')->with('ok', 'Empleado registrado.');
    }

    public function show(Empleado $empleado)
    {
        return view('empleados.show', compact('empleado'));
    }

    public function edit(Empleado $empleado)
    {
        return view('empleados.edit', compact('empleado'));
    }

    public function update(Request $request, Empleado $empleado)
    {
        $data = $request->validate([
            'NOMBRE_EMPLEADO' => 'required|string|max:80',
            'APELLIDO_EMPLEADO' => 'required|string|max:80',
            'DNI_EMPLEADO' => 'required|string|size:8|unique:empleados,DNI_EMPLEADO,' . $empleado->ID_EMPLEADO . ',ID_EMPLEADO',
            'EDAD_EMPLEADO' => 'nullable|integer|min:16|max:99',
            'TELEFONO_EMPLEADO' => 'nullable|string|size:9',
            'ESTADO_EMPLEADO' => 'required|in:ACTIVO,INACTIVO',
        ]);

        $empleado->update($data);
        return redirect()->route('empleados.index')->with('ok', 'Empleado actualizado.');
    }

    public function destroy(Empleado $empleado)
    {
        $empleado->delete();
        return redirect()->route('empleados.index')->with('ok', 'Empleado eliminado.');
    }
}
