<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Usuario;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    public function form()
    {
        return view('auth.login');
    }

    public function login(Request $request)
    {
        $data = $request->validate([
            'ID_USUARIO' => 'required|string',
            'CONTRASENA' => 'required|string',
        ]);

        $usuario = Usuario::where('ID_USUARIO', $data['ID_USUARIO'])
            ->where('ESTADO_USUARIO', 'ACTIVO')
            ->first();

        if (!$usuario || !Hash::check($data['CONTRASENA'], $usuario->CONTRASENA)) {
            return back()->with('error', 'Usuario o contraseña incorrectos.');
        }

        // ✅ Guardamos TODO lo necesario (incluye ID_EMPLEADO)
        $request->session()->put('usuario', [
            'ID_USUARIO'  => $usuario->ID_USUARIO,
            'ROL'         => $usuario->ROL,
            'ID_EMPLEADO' => $usuario->ID_EMPLEADO,
        ]);

        // (opcional pero recomendado)
        $request->session()->regenerate();

        return redirect()->route('dashboard');
    }


    public function logout(Request $request)
    {
        $request->session()->forget('usuario');
        $request->session()->invalidate();
        $request->session()->regenerateToken();

        return redirect()->route('login.form');
    }
}
