<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Producto;

class ProductoController extends Controller
{
    public function index(Request $request)
    {
        $tipos = Producto::query()
            ->select('TIPO_PRODUCTO')
            ->distinct()
            ->orderBy('TIPO_PRODUCTO')
            ->pluck('TIPO_PRODUCTO');

        $tipo = $request->get('tipo');

        $productos = Producto::query()
            ->when($tipo, fn($q) => $q->where('TIPO_PRODUCTO', $tipo))
            ->orderBy('ID_PRODUCTO')
            ->paginate(10)
            ->withQueryString();

        return view('productos.index', compact('productos', 'tipos'));
    }

    public function create()
    {
        return view('productos.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'ID_PRODUCTO' => 'required|string|max:20|unique:productos,ID_PRODUCTO',
            'TIPO_PRODUCTO' => 'required|in:ARETES,COLLARES,PULSERAS,ANILLOS,OTROS',
            'PRECIO_PRODUCTO' => 'required|numeric|min:0',
            'ESTADO_PRODUCTO' => 'required|in:ACTIVO,INACTIVO',
        ]);

        Producto::create($data);
        return redirect()->route('productos.index')->with('ok', 'Producto registrado.');
    }

    public function show(Producto $producto)
    {
        return view('productos.show', compact('producto'));
    }

    public function edit(Producto $producto)
    {
        return view('productos.edit', compact('producto'));
    }

    public function update(Request $request, Producto $producto)
    {
        $data = $request->validate([
            'TIPO_PRODUCTO' => 'required|in:ARETES,COLLARES,PULSERAS,ANILLOS,OTROS',
            'PRECIO_PRODUCTO' => 'required|numeric|min:0',
            'ESTADO_PRODUCTO' => 'required|in:ACTIVO,INACTIVO',
        ]);

        $producto->update($data);
        return redirect()->route('productos.index')->with('ok', 'Producto actualizado.');
    }

    public function destroy(Producto $producto)
    {
        $producto->delete();
        return redirect()->route('productos.index')->with('ok', 'Producto eliminado.');
    }
}
