<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\CierreCaja;
use App\Models\ReporteVenta;

class BloquearVentasDiaCerrado
{
    public function handle(Request $request, Closure $next)
    {
        $hoy = Carbon::today();

        $cierreHoy  = CierreCaja::whereDate('FECHA_CIERRE_CAJA', $hoy)->exists();
        $reporteHoy = ReporteVenta::whereDate('FECHA_REPORTE', $hoy)->exists();

        if ($cierreHoy || $reporteHoy) {
            return redirect()
                ->route('ventas.index')
                ->with('error', 'Día cerrado: reporte/cierre ya generado. Ventas habilitadas mañana.');
        }

        return $next($request);
    }
}
