<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AperturaCaja extends Model
{
    protected $table = 'apertura_cajas'; // ✅ debe coincidir con migración
    protected $primaryKey = 'ID_APERTURA';

    protected $fillable = [
        'FECHA_APERTURA',
        'MONTO_APERTURA',
        'ID_EMPLEADO'
    ];

    public function empleado()
    {
        return $this->belongsTo(Empleado::class, 'ID_EMPLEADO', 'ID_EMPLEADO');
    }

    public function cierres()
    {
        return $this->hasMany(CierreCaja::class, 'ID_APERTURA', 'ID_APERTURA');
    }
}
