<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CierreCaja extends Model
{
    protected $table = 'cierre_cajas'; // ✅ debe coincidir con migración
    protected $primaryKey = 'ID_CIERRE';

    protected $fillable = [
        'FECHA_CIERRE_CAJA',
        'ID_APERTURA',
        'ID_REPORTE',
        'MONTO_APERTURA',
        'EFECTIVO_VENTAS',
        'EFECTIVO_SISTEMA',
        'EFECTIVO_FISICO',
        'DINERO_SOBRANTE',
        'DINERO_FALTANTE',
        'OBSERVACION_CIERRE',
        'ESTADO_CIERRE',
        'ID_EMPLEADO'
    ];

    public function apertura()
    {
        return $this->belongsTo(AperturaCaja::class, 'ID_APERTURA', 'ID_APERTURA');
    }

    public function empleado()
    {
        return $this->belongsTo(Empleado::class, 'ID_EMPLEADO', 'ID_EMPLEADO');
    }

    // Si ya tienes ReporteVenta:
    public function reporte()
    {
        return $this->belongsTo(ReporteVenta::class, 'ID_REPORTE', 'ID_REPORTE');
    }

}
