<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Empleado extends Model
{
    protected $table = 'empleados';
    protected $primaryKey = 'ID_EMPLEADO';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'ID_EMPLEADO',
        'NOMBRE_EMPLEADO',
        'APELLIDO_EMPLEADO',
        'DNI_EMPLEADO',
        'EDAD_EMPLEADO',
        'TELEFONO_EMPLEADO',
        'ESTADO_EMPLEADO',
    ];

    public function usuario()
    {
        return $this->hasOne(Usuario::class, 'ID_EMPLEADO', 'ID_EMPLEADO');
    }
}
