<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Usuario extends Model
{
    protected $table = 'usuarios';
    protected $primaryKey = 'ID_USUARIO';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'ID_USUARIO',
        'ID_EMPLEADO',
        'CONTRASENA',
        'ROL',
        'ESTADO_USUARIO',
    ];

    public function empleado()
    {
        return $this->belongsTo(Empleado::class, 'ID_EMPLEADO', 'ID_EMPLEADO');
    }
}
